/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationContext;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationHelper;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationInventory;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationStatsContextData;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationLocalContextData;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationLogger;
import org.eclipse.scout.rt.dataobject.migration.MigrationDataObjectVisitor;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ApplicationScoped
public class DoStructureMigrator {
    public <T extends IDataObject> DoStructureMigratorResult<T> migrateDataObject(DoStructureMigrationContext ctx, String json, Class<T> valueType) {
        Assertions.assertNotNull((Object)json, (String)"json is required", (Object[])new Object[0]);
        return this.migrateDataObject(ctx, new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), valueType);
    }

    public <T extends IDataObject> DoStructureMigratorResult<T> migrateDataObject(DoStructureMigrationContext ctx, InputStream inputStream, Class<T> valueType) {
        Assertions.assertNotNull((Object)inputStream, (String)"inputStream is required", (Object[])new Object[0]);
        IDataObjectMapper dataObjectMapper = (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
        IDataObject dataObject = dataObjectMapper.readValueRaw(inputStream);
        return this.migrateDataObject(ctx, dataObject, valueType);
    }

    public <T extends IDataObject> DoStructureMigratorResult<T> migrateDataObject(DoStructureMigrationContext ctx, IDataObject dataObject, Class<T> valueType) {
        Assertions.assertNotNull(valueType, (String)"valueType is required", (Object[])new Object[0]);
        IDataObjectMapper dataObjectMapper = (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
        boolean changed = this.migrateDataObject(ctx, dataObject);
        String json = dataObjectMapper.writeValue(dataObject);
        IDataObject typedDataObject = (IDataObject)dataObjectMapper.readValue(json, valueType);
        return new DoStructureMigratorResult<IDataObject>(typedDataObject, changed);
    }

    public boolean migrateDataObject(DoStructureMigrationContext ctx, IDataObject dataObject) {
        return this.migrateDataObject(ctx, dataObject, (NamespaceVersion)null, new IDoStructureMigrationLocalContextData[0]);
    }

    public boolean migrateDataObject(DoStructureMigrationContext ctx, IDataObject dataObject, IDoStructureMigrationLocalContextData ... initialLocalContextData) {
        return this.migrateDataObject(ctx, dataObject, (NamespaceVersion)null, initialLocalContextData);
    }

    public boolean migrateDataObject(DoStructureMigrationContext ctx, IDataObject dataObject, NamespaceVersion toVersion, IDoStructureMigrationLocalContextData ... initialLocalContextData) {
        Assertions.assertNotNull((Object)ctx, (String)"ctx is required", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)dataObject, (String)"dataObject is required", (Object[])new Object[0]);
        DoStructureMigrationContext ctxCopy = ctx.initializedCopy(initialLocalContextData);
        DoStructureMigrationStatsContextData stats = ctxCopy.getStats();
        IDoStructureMigrationLogger logger = ctxCopy.getLogger();
        long start = System.nanoTime();
        stats.incrementDataObjectsProcessed();
        logger.trace("Data object before migration: {}", dataObject);
        Map<String, NamespaceVersion> typeVersions = ((DoStructureMigrationHelper)BEANS.get(DoStructureMigrationHelper.class)).collectRawDataObjectTypeVersions(dataObject);
        if (typeVersions.isEmpty()) {
            logger.debug("No data object entities with a type name found within {}", dataObject);
            stats.addMigrationDuration(start);
            return false;
        }
        List<NamespaceVersion> versions = ((DoStructureMigrationInventory)BEANS.get(DoStructureMigrationInventory.class)).getVersions(typeVersions, toVersion);
        if (versions.isEmpty()) {
            stats.addMigrationDuration(start);
            return false;
        }
        boolean changed = false;
        for (NamespaceVersion version : versions) {
            changed |= this.migrateDataObject(ctxCopy, version, dataObject);
        }
        if (changed) {
            stats.incrementDataObjectsChanged();
            logger.trace("Data object after migration: {}", dataObject);
        }
        logger.debug("Applied migrations [{} -> {}] on {}", CollectionUtility.firstElement(versions), CollectionUtility.lastElement(versions), dataObject);
        stats.addMigrationDuration(start);
        return changed;
    }

    protected boolean migrateDataObject(DoStructureMigrationContext ctx, NamespaceVersion version, IDataObject dataObject) {
        MigrationDataObjectVisitor visitor = new MigrationDataObjectVisitor(ctx, version);
        visitor.migrate(dataObject);
        return visitor.isChanged();
    }

    public static class DoStructureMigratorResult<T extends IDataObject> {
        private T m_dataObject;
        private boolean m_changed;

        public DoStructureMigratorResult(T dataObject, boolean changed) {
            this.m_dataObject = dataObject;
            this.m_changed = changed;
        }

        public T getDataObject() {
            return this.m_dataObject;
        }

        public boolean isChanged() {
            return this.m_changed;
        }
    }
}

