/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.dataobject.ITypeVersion;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;

public abstract class AbstractTypeVersion
implements ITypeVersion {
    private final NamespaceVersion m_version;
    private final Collection<NamespaceVersion> m_dependencies;
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("(\\w+?)_(\\d+(?:_\\d+)*)");

    protected AbstractTypeVersion() {
        this.m_version = (NamespaceVersion)Assertions.assertNotNull((Object)AbstractTypeVersion.fromClassName(this.getClass()), (String)"version is required", (Object[])new Object[0]);
        this.m_dependencies = AbstractTypeVersion.resolveDependencies(this.getDependencyClasses());
    }

    protected AbstractTypeVersion(NamespaceVersion version) {
        this.m_version = (NamespaceVersion)Assertions.assertNotNull((Object)version, (String)"version is required", (Object[])new Object[0]);
        this.m_dependencies = AbstractTypeVersion.resolveDependencies(this.getDependencyClasses());
    }

    public final NamespaceVersion getVersion() {
        return this.m_version;
    }

    @Override
    public final Collection<NamespaceVersion> getDependencies() {
        return this.m_dependencies;
    }

    protected Collection<Class<? extends ITypeVersion>> getDependencyClasses() {
        return Collections.emptyList();
    }

    static NamespaceVersion fromClassName(Class<? extends ITypeVersion> typeVersionClass) {
        if (typeVersionClass == null) {
            return null;
        }
        Matcher m = CLASS_NAME_PATTERN.matcher(typeVersionClass.getSimpleName());
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("Class name does not match expected pattern [simpleName='%s', expectedPattern=%s]", typeVersionClass.getSimpleName(), CLASS_NAME_PATTERN));
        }
        return NamespaceVersion.of((String)StringUtility.lowercaseFirst((String)m.group(1)), (String)m.group(2).replace('_', '.'));
    }

    static List<NamespaceVersion> resolveDependencies(Collection<Class<? extends ITypeVersion>> dependencyClasses) {
        return Collections.unmodifiableList(dependencyClasses.stream().map(dependencyClass -> ((ITypeVersion)BEANS.get((Class)dependencyClass)).getVersion()).collect(Collectors.toList()));
    }
}

