/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import org.eclipse.scout.rt.dataobject.DoEntity;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@Bean
public class DoEntityBuilder {
    protected IDoEntity m_entity;

    @PostConstruct
    protected void init() {
        this.m_entity = (IDoEntity)BEANS.get(DoEntity.class);
    }

    public DoEntityBuilder put(String attributeName, Object value) {
        this.m_entity.put(attributeName, value);
        return this;
    }

    public DoEntityBuilder putIf(String attributeName, Object value, Predicate<? super Object> predicate) {
        this.m_entity.putIf(attributeName, value, predicate);
        return this;
    }

    public <V> DoEntityBuilder putList(String attributeName, List<V> value) {
        this.m_entity.putList(attributeName, value);
        return this;
    }

    public <V> DoEntityBuilder putListIf(String attributeName, List<V> value, Predicate<? super List<V>> predicate) {
        this.m_entity.putListIf(attributeName, value, predicate);
        return this;
    }

    @SafeVarargs
    public final <V> DoEntityBuilder putList(String attributeName, V ... values) {
        this.m_entity.putList(attributeName, CollectionUtility.arrayList((Object[])values));
        return this;
    }

    public IDoEntity build() {
        return this.m_entity;
    }

    public String buildString() {
        return ((IDataObjectMapper)BEANS.get(IDataObjectMapper.class)).writeValue(this.m_entity);
    }
}

