/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import org.eclipse.scout.rt.dataobject.AbstractDoCollection;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.IDataObject;

public final class DoList<V>
extends AbstractDoCollection<V, List<V>>
implements IDataObject {
    public DoList() {
        this(null, null, null);
    }

    DoList(String attributeName, Consumer<DoNode<List<V>>> lazyCreate, List<V> initialValue) {
        super(attributeName, lazyCreate, DoList.emptyListIfNull(initialValue));
    }

    public static <V> DoList<V> of(List<V> list) {
        return new DoList<V>(null, null, list);
    }

    static <V> List<V> emptyListIfNull(List<V> list) {
        return list != null ? list : new ArrayList();
    }

    @Override
    public void set(List<V> newValue) {
        super.set(DoList.emptyListIfNull(newValue));
    }

    public V get(int index) {
        if (!this.exists()) {
            throw new IndexOutOfBoundsException("Node doesn't exist");
        }
        return (V)((List)this.get()).get(index);
    }

    public V remove(int index) {
        if (!this.exists()) {
            throw new IndexOutOfBoundsException("Node doesn't exist");
        }
        return (V)((List)this.get()).remove(index);
    }

    public V first() {
        return this.size() == 0 ? null : (V)this.get(0);
    }

    public V last() {
        return this.size() == 0 ? null : (V)this.get(((List)this.get()).size() - 1);
    }

    public ListIterator<V> listIterator() {
        if (!this.exists()) {
            return Collections.emptyListIterator();
        }
        return ((List)this.get()).listIterator();
    }

    public void sort(Comparator<V> comparator) {
        if (!this.exists()) {
            return;
        }
        List list = (List)this.get();
        list.sort(comparator);
    }

    public String toString() {
        return "DoList [m_list=" + (this.exists() ? this.get() : "[]") + " exists=" + this.exists() + "]";
    }
}

