/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.id;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.dataobject.id.IdFactory;
import org.eclipse.scout.rt.dataobject.id.IdTypeName;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.inventory.ClassInventory;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@CreateImmediately
public class IdExternalFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(IdExternalFormatter.class);
    protected final LazyValue<IdFactory> m_idFactory = new LazyValue(IdFactory.class);
    protected final Map<String, Class<? extends IId<?>>> m_nameToClassMap = new HashMap();
    protected final Map<Class<? extends IId<?>>, String> m_classToNameMap = new HashMap();

    @PostConstruct
    protected void createClassCache() {
        for (IClassInfo classInfo : ClassInventory.get().getKnownAnnotatedTypes(IdTypeName.class)) {
            String typeName = (String)classInfo.getAnnotationValue(IdTypeName.class, "value");
            Assertions.assertNotNullOrEmpty((String)typeName, (String)"Invalid value for @{} on {} (must not be null or empty)", (Object[])new Object[]{IdTypeName.class.getSimpleName(), classInfo.resolveClass().getName()});
            try {
                Class<IId> idClass = classInfo.resolveClass().asSubclass(IId.class);
                Class<IId> registeredIdClass = this.m_nameToClassMap.put(typeName, idClass);
                String registeredTypeName = this.m_classToNameMap.put(idClass, typeName);
                this.checkDuplicateIdTypeNames(idClass, typeName, registeredIdClass, registeredTypeName);
            }
            catch (ClassCastException classCastException) {
                LOG.warn("Class {} is annotated with @{} but does not implement {}. Skipping class.", new Object[]{classInfo.resolveClass().getName(), IdTypeName.class.getSimpleName(), IId.class.getName()});
            }
        }
        LOG.debug("Registered {} id types", (Object)this.m_nameToClassMap.size());
    }

    protected void checkDuplicateIdTypeNames(Class<?> clazz, String typeName, Class<?> existingClass, String existingName) {
        Assertions.assertNull(existingClass, (String)"{} and {} have the same type name '{}'. Use an unique @{} annotation value.", (Object[])new Object[]{clazz, existingClass, typeName, IdTypeName.class.getSimpleName()});
        Assertions.assertNull((Object)existingName, (String)"{} is annotated with @{} value '{}', but was already registered with type name '{}'. Register each class only once.", (Object[])new Object[]{clazz, IdTypeName.class.getSimpleName(), typeName, existingName});
    }

    public <ID extends IId<?>> String toExternalForm(ID id) {
        String typeName = (String)Assertions.assertNotNull((Object)this.getTypeName(id), (String)"Missing @{} in class {}", (Object[])new Object[]{IdTypeName.class.getSimpleName(), id.getClass().getName()});
        String rawId = id.unwrapAsString();
        return String.valueOf(typeName) + ":" + rawId;
    }

    public IId<?> fromExternalForm(String externalForm) {
        if (externalForm == null) {
            return null;
        }
        String[] tmp = externalForm.split(":");
        if (tmp.length != 2) {
            throw new IllegalArgumentException("externalForm '" + externalForm + "' is invalid");
        }
        String typeName = tmp[0];
        Class<? extends IId<?>> idClass = this.m_nameToClassMap.get(typeName);
        if (idClass == null) {
            throw new ProcessingException("No class found for type name '{}'", new Object[]{typeName});
        }
        return ((IdFactory)this.m_idFactory.get()).createFromString(idClass, tmp[1]);
    }

    public IId<?> fromExternalFormLenient(String externalForm) {
        if (externalForm == null) {
            return null;
        }
        String[] tmp = externalForm.split(":", 2);
        if (tmp.length != 2) {
            return null;
        }
        String typeName = tmp[0];
        Class<? extends IId<?>> idClass = this.m_nameToClassMap.get(typeName);
        if (idClass == null) {
            return null;
        }
        return ((IdFactory)this.m_idFactory.get()).createFromString(idClass, tmp[1]);
    }

    public String getTypeName(Class<? extends IId<?>> idClass) {
        return this.m_classToNameMap.get(idClass);
    }

    public Class<? extends IId<?>> getIdClass(String typeName) {
        return this.m_nameToClassMap.get(typeName);
    }

    public String getTypeName(IId<?> id) {
        return this.getTypeName(id.getClass());
    }
}

