/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.lookup;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.dataobject.enumeration.IEnum;
import org.eclipse.scout.rt.dataobject.lookup.AbstractLookupRestrictionDo;
import org.eclipse.scout.rt.dataobject.lookup.AbstractLookupRowDo;
import org.eclipse.scout.rt.dataobject.lookup.LookupResponse;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.nls.CollatorProvider;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.platform.util.StreamUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ApplicationScoped
public class LookupHelper {
    protected static final int DEFAULT_MAX_ROWS = 100;
    protected static final String WILDCARD = "*";
    protected static final String WILDCARD_REPLACE = "@wildcard@";
    protected static final String MATCH_ALL_REGEX = ".*";

    public <LOOKUP_ROW extends AbstractLookupRowDo<ID>, ID, RESTRICTION extends AbstractLookupRestrictionDo<ID>, DATA> LookupResponse<LOOKUP_ROW> filterData(RESTRICTION restriction, Stream<DATA> data, Function<DATA, ID> idAccessor, Function<DATA, String> textAccessor, Class<LOOKUP_ROW> rowClass) {
        return this.filterData(restriction, data, idAccessor, textAccessor, null, LookupHelper.truePredicate(), rowClass, LookupHelper.identityMapper(), LookupHelper.lookupRowDoComparatorByText());
    }

    public <LOOKUP_ROW extends AbstractLookupRowDo<ID>, ID, RESTRICTION extends AbstractLookupRestrictionDo<ID>, DATA> LookupResponse<LOOKUP_ROW> filterData(RESTRICTION restriction, Stream<DATA> data, Function<DATA, ID> idAccessor, Function<DATA, String> textAccessor, Class<LOOKUP_ROW> rowClass, Comparator<LOOKUP_ROW> lookupRowDoComparator) {
        return this.filterData(restriction, data, idAccessor, textAccessor, null, LookupHelper.truePredicate(), rowClass, LookupHelper.identityMapper(), lookupRowDoComparator);
    }

    public <LOOKUP_ROW extends AbstractLookupRowDo<ID>, ID, RESTRICTION extends AbstractLookupRestrictionDo<ID>, DATA> LookupResponse<LOOKUP_ROW> filterData(RESTRICTION restriction, Stream<DATA> data, Function<DATA, ID> idAccessor, Function<DATA, String> textAccessor, Function<DATA, Boolean> activeAccessor, Class<LOOKUP_ROW> rowClass) {
        return this.filterData(restriction, data, idAccessor, textAccessor, activeAccessor, LookupHelper.truePredicate(), rowClass, LookupHelper.identityMapper(), LookupHelper.lookupRowDoComparatorByText());
    }

    public <LOOKUP_ROW extends AbstractLookupRowDo<ID>, ID, RESTRICTION extends AbstractLookupRestrictionDo<ID>, DATA> LookupResponse<LOOKUP_ROW> filterData(RESTRICTION restriction, Stream<DATA> data, Function<DATA, ID> idAccessor, Function<DATA, String> textAccessor, Function<DATA, Boolean> activeAccessor, Predicate<DATA> additionalFilter, Class<LOOKUP_ROW> rowClass) {
        return this.filterData(restriction, data, idAccessor, textAccessor, activeAccessor, additionalFilter, rowClass, LookupHelper.identityMapper(), LookupHelper.lookupRowDoComparatorByText());
    }

    public <LOOKUP_ROW extends AbstractLookupRowDo<ID>, ID, RESTRICTION extends AbstractLookupRestrictionDo<ID>, DATA> LookupResponse<LOOKUP_ROW> filterData(RESTRICTION restriction, Stream<DATA> dataStream, Function<DATA, ID> idAccessor, Function<DATA, String> textAccessor, Function<DATA, Boolean> activeAccessor, Predicate<DATA> additionalFilter, Class<LOOKUP_ROW> rowClass, BiFunction<LOOKUP_ROW, DATA, LOOKUP_ROW> additionalMapper, Comparator<LOOKUP_ROW> lookupRowDoComparator) {
        Stream<AbstractLookupRowDo> stream = dataStream.filter(this.restrictionPredicate(restriction, idAccessor, textAccessor, activeAccessor)).filter(additionalFilter).map(data -> {
            AbstractLookupRowDo row = (AbstractLookupRowDo)BEANS.get((Class)rowClass);
            row.withId(idAccessor.apply(data)).withText((String)textAccessor.apply(data));
            if (activeAccessor != null) {
                row.withActive((Boolean)activeAccessor.apply(data));
            }
            return (AbstractLookupRowDo)additionalMapper.apply(row, data);
        });
        if (lookupRowDoComparator != null) {
            stream = stream.sorted(lookupRowDoComparator);
        }
        List rows = stream.collect(Collectors.toList());
        return LookupResponse.create(rows);
    }

    public <LOOKUP_ROW extends AbstractLookupRowDo<ENUM>, ENUM extends Enum<?>, RESTRICTION extends AbstractLookupRestrictionDo<ENUM>> LookupResponse<LOOKUP_ROW> filterEnum(RESTRICTION restriction, Class<ENUM> enumClass, Class<LOOKUP_ROW> rowClass) {
        return this.filterData(restriction, Arrays.stream((Enum[])enumClass.getEnumConstants()), Function.identity(), LookupHelper.enumTextResolver(), rowClass);
    }

    public <LOOKUP_ROW extends AbstractLookupRowDo<ENUM>, ENUM extends Enum<?>, RESTRICTION extends AbstractLookupRestrictionDo<ENUM>> LookupResponse<LOOKUP_ROW> filterEnumKeepSorting(RESTRICTION restriction, Class<ENUM> enumClass, Class<LOOKUP_ROW> rowClass) {
        return this.filterData(restriction, Arrays.stream((Enum[])enumClass.getEnumConstants()), Function.identity(), LookupHelper.enumTextResolver(), null, LookupHelper.truePredicate(), rowClass, LookupHelper.identityMapper(), null);
    }

    public int maxRowCount(AbstractLookupRestrictionDo<?> restriction) {
        return NumberUtility.nvl((Integer)restriction.getMaxRowCount(), (int)100);
    }

    public static <T> Predicate<T> truePredicate() {
        return t -> true;
    }

    public static <T, R> BiFunction<T, R, T> identityMapper() {
        return (r, d) -> r;
    }

    public static <ENUM extends IEnum> Function<ENUM, String> enumTextResolver() {
        return e -> e == null ? null : e.text();
    }

    public static <LOOKUP_ROW extends AbstractLookupRowDo<?>> Comparator<LOOKUP_ROW> lookupRowDoComparatorByText() {
        Collator collator = ((CollatorProvider)BEANS.get(CollatorProvider.class)).getInstance();
        collator.setStrength(2);
        return Comparator.comparing(AbstractLookupRowDo::getText, Comparator.nullsFirst(collator));
    }

    public <ID, RESTRICTION extends AbstractLookupRestrictionDo<ID>, DATA> Predicate<DATA> restrictionPredicate(RESTRICTION restriction, Function<DATA, ID> idAccessor, Function<DATA, String> textAccessor, Function<DATA, Boolean> activeAccessor) {
        if (restriction == null) {
            return LookupHelper.truePredicate();
        }
        List ids = restriction.getIds();
        Predicate<Object> predicate = this.textPatternPredicate(restriction.getText(), textAccessor);
        if (idAccessor != null && !ids.isEmpty()) {
            predicate = predicate.and(data -> ids.contains(idAccessor.apply(data)));
        }
        if (activeAccessor != null) {
            predicate = predicate.and(this.activePredicate(restriction.getActive(), activeAccessor));
        }
        return predicate;
    }

    public <DATA> Predicate<DATA> textPatternPredicate(String textPattern, Function<DATA, String> textAccessor) {
        if (textPattern == null) {
            return LookupHelper.truePredicate();
        }
        Assertions.assertNotNull(textAccessor, (String)"textAccessor is required", (Object[])new Object[0]);
        Pattern pattern = this.createTextSearchPattern(textPattern);
        return data -> {
            if (data == null) {
                return false;
            }
            String text = (String)textAccessor.apply(data);
            return text != null && pattern.matcher(text).matches();
        };
    }

    public <DATA> Predicate<DATA> activePredicate(Boolean active, Function<DATA, Boolean> activeAccessor) {
        if (active == null) {
            return LookupHelper.truePredicate();
        }
        Assertions.assertNotNull(activeAccessor, (String)"activeAccessor is required", (Object[])new Object[0]);
        boolean activeBoolean = active;
        return data -> {
            if (data == null) {
                return false;
            }
            Boolean dataActive = (Boolean)activeAccessor.apply(data);
            return dataActive != null && dataActive == activeBoolean;
        };
    }

    protected Pattern createTextSearchPattern(String text) {
        if (text == null) {
            text = "";
        }
        text = text.replace(WILDCARD, WILDCARD_REPLACE);
        text = StringUtility.escapeRegexMetachars((CharSequence)text);
        if (!(text = text.replace(WILDCARD_REPLACE, MATCH_ALL_REGEX)).contains(MATCH_ALL_REGEX)) {
            text = String.valueOf(text) + MATCH_ALL_REGEX;
        }
        if (!text.startsWith(MATCH_ALL_REGEX)) {
            text = MATCH_ALL_REGEX + text;
        }
        return Pattern.compile(text, 98);
    }

    public <V, ID> Map<ID, String> resolve(Stream<V> values, Function<V, ID> idExtractor, Function<Set<ID>, List<? extends AbstractLookupRowDo<ID>>> textResolver) {
        Set ids = values.map(idExtractor).filter(Objects::nonNull).collect(Collectors.toSet());
        return (Map)textResolver.apply(ids).stream().collect(StreamUtility.toMap(AbstractLookupRowDo::getId, AbstractLookupRowDo::getText));
    }
}

