/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.mapping;

import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.mapping.DoEntityMappings;
import org.eclipse.scout.rt.dataobject.mapping.IDoEntityMapperExtension;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.util.Assertions;

public abstract class AbstractDoEntityMapper<DO_ENTITY extends IDoEntity, PEER> {
    protected DoEntityMappings<DO_ENTITY, PEER> m_mappings;

    public AbstractDoEntityMapper() {
        this.reset();
    }

    protected void extendMappings(DoEntityMappings<DO_ENTITY, PEER> mappings) {
        BEANS.all(IDoEntityMapperExtension.class).stream().filter(extension -> extension.getMapperClass().isInstance(this)).forEach(extension -> extension.extendMappings(mappings));
    }

    protected abstract void initMappings(DoEntityMappings<DO_ENTITY, PEER> var1);

    public void fromDo(DO_ENTITY doEntity, PEER target) {
        Assertions.assertNotNull(doEntity, (String)"doEntity is required", (Object[])new Object[0]);
        Assertions.assertNotNull(target, (String)"target is required", (Object[])new Object[0]);
        if (Platform.get().inDevelopmentMode()) {
            this.reset();
        }
        this.m_mappings.fromDo(doEntity, target);
    }

    public void toDo(PEER source, DO_ENTITY doEntity) {
        Assertions.assertNotNull(source, (String)"source is required", (Object[])new Object[0]);
        Assertions.assertNotNull(doEntity, (String)"doEntity is required", (Object[])new Object[0]);
        if (Platform.get().inDevelopmentMode()) {
            this.reset();
        }
        this.m_mappings.toDo(source, doEntity);
    }

    protected void reset() {
        DoEntityMappings mappings = new DoEntityMappings();
        this.initMappings(mappings);
        this.extendMappings(mappings);
        this.m_mappings = mappings;
    }
}

