/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.IDoEntityContribution;
import org.eclipse.scout.rt.dataobject.mapping.IDoEntityMapping;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.util.BooleanUtility;

public class DoEntityMappings<DO_ENTITY extends IDoEntity, PEER> {
    protected final List<IDoEntityMapping<DO_ENTITY, PEER>> m_mappings = new ArrayList<IDoEntityMapping<DO_ENTITY, PEER>>();

    public void toDo(PEER source, DO_ENTITY doEntity) {
        this.m_mappings.forEach(mapping -> mapping.toDo(source, doEntity));
    }

    public void fromDo(DO_ENTITY doEntity, PEER target) {
        this.m_mappings.forEach(n -> n.fromDo(doEntity, target));
    }

    public <VALUE> DoEntityMappings<DO_ENTITY, PEER> with(IDoEntityMapping<DO_ENTITY, PEER> mapping) {
        this.m_mappings.add(mapping);
        return this;
    }

    public <VALUE> DoEntityMappings<DO_ENTITY, PEER> with(final BiConsumer<PEER, DO_ENTITY> toDoConsumer, final BiConsumer<DO_ENTITY, PEER> fromDoConsumer) {
        this.m_mappings.add(new IDoEntityMapping<DO_ENTITY, PEER>(){

            @Override
            public void toDo(PEER source, DO_ENTITY dataObject) {
                if (toDoConsumer != null) {
                    toDoConsumer.accept(source, dataObject);
                }
            }

            @Override
            public void fromDo(DO_ENTITY dataObject, PEER target) {
                if (fromDoConsumer != null) {
                    fromDoConsumer.accept(dataObject, target);
                }
            }
        });
        return this;
    }

    public <VALUE> DoEntityMappings<DO_ENTITY, PEER> with(Function<DO_ENTITY, DoNode<VALUE>> doNode, Function<PEER, VALUE> valueGetter) {
        return this.with(doNode, valueGetter, null);
    }

    public <VALUE> DoEntityMappings<DO_ENTITY, PEER> with(final Function<DO_ENTITY, DoNode<VALUE>> doNodeFunction, final Function<PEER, VALUE> valueGetter, final BiConsumer<PEER, VALUE> valueSetter) {
        this.m_mappings.add(new IDoEntityMapping<DO_ENTITY, PEER>(){

            @Override
            public void toDo(PEER peer, DO_ENTITY doEntity) {
                if (valueGetter == null) {
                    return;
                }
                Object value = valueGetter.apply(peer);
                DoNode doNode = (DoNode)doNodeFunction.apply(doEntity);
                doNode.set(value);
            }

            @Override
            public void fromDo(DO_ENTITY dataObject, PEER peer) {
                if (valueSetter == null) {
                    return;
                }
                DoNode doNode = (DoNode)doNodeFunction.apply(dataObject);
                if (!doNode.exists()) {
                    return;
                }
                valueSetter.accept(peer, doNode.get());
            }
        });
        return this;
    }

    public <VALUE> DoEntityMappings<DO_ENTITY, PEER> withHolder(Function<DO_ENTITY, DoNode<VALUE>> doNodeFunction, Function<PEER, IHolder<VALUE>> holderFunction) {
        return this.with(doNodeFunction, peer -> ((IHolder)holderFunction.apply(peer)).getValue(), (peer, value) -> ((IHolder)holderFunction.apply(peer)).setValue(value));
    }

    public <CHILD_DO_ENTITY extends IDoEntity, CHILD_PEER> DoEntityMappings<DO_ENTITY, PEER> withChildMapping(final Function<DO_ENTITY, DoNode<CHILD_DO_ENTITY>> childNodeFunction, final Class<CHILD_DO_ENTITY> childDoEntityClass, final Function<PEER, CHILD_PEER> childPeerFunction, Consumer<DoEntityMappings<CHILD_DO_ENTITY, CHILD_PEER>> initChildMappingsConsumer) {
        final DoEntityMappings<DO_ENTITY, PEER> mappings = new DoEntityMappings<DO_ENTITY, PEER>();
        initChildMappingsConsumer.accept(mappings);
        this.m_mappings.add(new IDoEntityMapping<DO_ENTITY, PEER>(){

            @Override
            public void toDo(PEER peer, DO_ENTITY doEntity) {
                Object childPeer = childPeerFunction.apply(peer);
                DoNode childNode = (DoNode)childNodeFunction.apply(doEntity);
                IDoEntity childDoEntity = (IDoEntity)childNode.get();
                if (childDoEntity == null) {
                    childDoEntity = (IDoEntity)BEANS.get((Class)childDoEntityClass);
                    childNode.set(childDoEntity);
                }
                mappings.toDo(childPeer, childDoEntity);
            }

            @Override
            public void fromDo(DO_ENTITY doEntity, PEER peer) {
                DoNode childNode = (DoNode)childNodeFunction.apply(doEntity);
                if (!childNode.exists()) {
                    return;
                }
                Object childPeer = childPeerFunction.apply(peer);
                IDoEntity childDoEntity = (IDoEntity)childNode.get();
                if (childDoEntity != null) {
                    mappings.fromDo(childDoEntity, childPeer);
                }
            }
        });
        return this;
    }

    public <CHILD_DO_ENTITY extends IDoEntity, CHILD_PEER> DoEntityMappings<DO_ENTITY, PEER> withChildMapping(final Function<DO_ENTITY, DoNode<CHILD_DO_ENTITY>> childNodeFunction, final Class<CHILD_DO_ENTITY> childDoEntityClass, final Function<PEER, CHILD_PEER> childPeerFunction, final BiConsumer<CHILD_PEER, CHILD_DO_ENTITY> toDoConsumer, final BiConsumer<CHILD_PEER, CHILD_DO_ENTITY> fromDoConsumer) {
        this.m_mappings.add(new IDoEntityMapping<DO_ENTITY, PEER>(){

            @Override
            public void toDo(PEER peer, DO_ENTITY dataObject) {
                Object childPeer = childPeerFunction.apply(peer);
                DoNode childDoNode = (DoNode)childNodeFunction.apply(dataObject);
                IDoEntity childDo = (IDoEntity)childDoNode.get();
                if (childDo == null) {
                    childDo = (IDoEntity)BEANS.get((Class)childDoEntityClass);
                    childDoNode.set(childDo);
                }
                toDoConsumer.accept(childPeer, childDo);
            }

            @Override
            public void fromDo(DO_ENTITY dataObject, PEER peer) {
                DoNode childNode = (DoNode)childNodeFunction.apply(dataObject);
                if (!childNode.exists()) {
                    return;
                }
                Object childPeer = childPeerFunction.apply(peer);
                IDoEntity childDo = (IDoEntity)childNode.get();
                if (childDo != null) {
                    fromDoConsumer.accept(childPeer, childDo);
                }
            }
        });
        return this;
    }

    public <CONTRIBUTION_DO_ENTITY extends IDoEntityContribution> DoEntityMappings<DO_ENTITY, PEER> withContribution(Class<CONTRIBUTION_DO_ENTITY> contributionClass, Consumer<DoEntityMappings<CONTRIBUTION_DO_ENTITY, PEER>> contributionMappingsConsumer) {
        return this.withContribution(contributionClass, (CONTRIBUTION_DO_ENTITY x) -> true, contributionMappingsConsumer);
    }

    public <CONTRIBUTION_DO_ENTITY extends IDoEntityContribution> DoEntityMappings<DO_ENTITY, PEER> withContribution(final Class<CONTRIBUTION_DO_ENTITY> contributionClass, final Predicate<CONTRIBUTION_DO_ENTITY> addPredicate, Consumer<DoEntityMappings<CONTRIBUTION_DO_ENTITY, PEER>> contributionMappingsConsumer) {
        final DoEntityMappings<DO_ENTITY, PEER> mappings = new DoEntityMappings<DO_ENTITY, PEER>();
        contributionMappingsConsumer.accept(mappings);
        this.m_mappings.add(new IDoEntityMapping<DO_ENTITY, PEER>(){

            @Override
            public void toDo(PEER peer, DO_ENTITY doEntity) {
                IDoEntityContribution contribution = (IDoEntityContribution)BEANS.get((Class)contributionClass);
                mappings.toDo(peer, contribution);
                if (addPredicate.test(contribution)) {
                    doEntity.putContribution(contribution);
                }
            }

            @Override
            public void fromDo(DO_ENTITY doEntity, PEER peer) {
                Object contribution = doEntity.getContribution(contributionClass);
                if (contribution != null) {
                    mappings.fromDo(contribution, peer);
                }
            }
        });
        return this;
    }

    public <CONTRIBUTION_DO_ENTITY extends IDoEntityContribution, SUB_PEER extends PEER> DoEntityMappings<DO_ENTITY, PEER> withContribution(Class<CONTRIBUTION_DO_ENTITY> contributionClass, Class<SUB_PEER> subPeerClass, Consumer<DoEntityMappings<CONTRIBUTION_DO_ENTITY, SUB_PEER>> contributionMappingsConsumer) {
        return this.withContribution(contributionClass, subPeerClass, x -> true, contributionMappingsConsumer);
    }

    public <CONTRIBUTION_DO_ENTITY extends IDoEntityContribution, SUB_PEER extends PEER> DoEntityMappings<DO_ENTITY, PEER> withContribution(Class<CONTRIBUTION_DO_ENTITY> contributionClass, Class<SUB_PEER> subPeerClass, Predicate<CONTRIBUTION_DO_ENTITY> addPredicate, Consumer<DoEntityMappings<CONTRIBUTION_DO_ENTITY, SUB_PEER>> contributionMappingsConsumer) {
        this.withContribution(contributionClass, addPredicate, (DoEntityMappings<CONTRIBUTION_DO_ENTITY, PEER> m) -> {
            DoEntityMappings doEntityMappings = m.withChainedMapping(contributionClass, subPeerClass, contributionMappingsConsumer);
        });
        return this;
    }

    public <SUB_DO_ENTITY extends DO_ENTITY, SUB_PEER extends PEER> DoEntityMappings<DO_ENTITY, PEER> withChainedMapping(final Class<SUB_DO_ENTITY> subDoEntityClass, final Class<SUB_PEER> subPeerClass, Consumer<DoEntityMappings<SUB_DO_ENTITY, SUB_PEER>> mappingsConsumer) {
        final DoEntityMappings<DO_ENTITY, PEER> mappings = new DoEntityMappings<DO_ENTITY, PEER>();
        mappingsConsumer.accept(mappings);
        this.m_mappings.add(new IDoEntityMapping<DO_ENTITY, PEER>(){

            @Override
            public void toDo(PEER source, DO_ENTITY dataObject) {
                this.validateType(source, dataObject);
                mappings.toDo(source, dataObject);
            }

            @Override
            public void fromDo(DO_ENTITY dataObject, PEER target) {
                this.validateType(target, dataObject);
                mappings.fromDo(dataObject, target);
            }

            private void validateType(PEER peer, DO_ENTITY doEntity) {
                if (!subDoEntityClass.isInstance(doEntity) || !subPeerClass.isInstance(peer)) {
                    throw new PlatformException("Peer {} or do entity {} is not is not of expected type: {} or {}", new Object[]{peer, doEntity, subDoEntityClass, subPeerClass});
                }
            }
        });
        return this;
    }

    public static <E> BiConsumer<E, Boolean> toPrimitiveBoolean(BiConsumer<E, Boolean> consumer) {
        return (target, value) -> consumer.accept(target, BooleanUtility.nvl((Boolean)value));
    }
}

