/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.dataobject.AbstractDataObjectVisitor;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationContext;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationHelper;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationInventory;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationHandler;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationTargetContextData;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;

public class DoStructureMigrationDataObjectVisitor
extends AbstractDataObjectVisitor {
    protected final DoStructureMigrationHelper m_helper = (DoStructureMigrationHelper)BEANS.get(DoStructureMigrationHelper.class);
    protected final DoStructureMigrationInventory m_inventory = (DoStructureMigrationInventory)BEANS.get(DoStructureMigrationInventory.class);
    protected final DoStructureMigrationContext m_ctx;
    protected final NamespaceVersion m_version;
    protected final Map<String, IDoStructureMigrationHandler> m_migrationHandlerPerTypeName;
    protected boolean m_changed = false;

    public DoStructureMigrationDataObjectVisitor(DoStructureMigrationContext ctx, NamespaceVersion version) {
        this.m_ctx = ctx;
        this.m_version = version;
        this.m_migrationHandlerPerTypeName = this.m_inventory.getMigrationHandlers(version);
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public void migrate(IDataObject dataObject) {
        this.visit(dataObject);
    }

    @Override
    protected void caseDoEntity(IDoEntity entity) {
        this.migrateInternal(entity);
        List<IDoStructureMigrationTargetContextData> localContextDataList = this.pushLocalContextData(entity);
        try {
            super.caseDoEntity(entity);
        }
        catch (Throwable throwable) {
            localContextDataList.forEach(this.m_ctx::remove);
            throw throwable;
        }
        localContextDataList.forEach(this.m_ctx::remove);
    }

    protected List<IDoStructureMigrationTargetContextData> pushLocalContextData(IDoEntity doEntity) {
        ArrayList<IDoStructureMigrationTargetContextData> localContextDataList = new ArrayList<IDoStructureMigrationTargetContextData>();
        Set<Class<? extends IDoStructureMigrationTargetContextData>> contextDataClasses = this.m_inventory.getDoMigrationContextValues(doEntity);
        for (Class<? extends IDoStructureMigrationTargetContextData> contextDataClass : contextDataClasses) {
            IDoStructureMigrationTargetContextData contextValue = (IDoStructureMigrationTargetContextData)BEANS.get(contextDataClass);
            if (!contextValue.initialize(this.m_ctx, doEntity)) continue;
            localContextDataList.add(contextValue);
        }
        localContextDataList.forEach(this.m_ctx::push);
        return localContextDataList;
    }

    protected void migrateInternal(IDoEntity doEntity) {
        if (!this.m_helper.isMigrationApplicable(doEntity, this.m_version)) {
            return;
        }
        String typeName = this.m_helper.getType(doEntity);
        IDoStructureMigrationHandler migrationHandler = this.m_migrationHandlerPerTypeName.get(typeName);
        if (migrationHandler == null) {
            return;
        }
        this.m_changed |= migrationHandler.applyMigration(this.m_ctx, doEntity);
    }
}

