/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.dataobject.AbstractReplacingDataObjectVisitor;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationContext;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationInventory;
import org.eclipse.scout.rt.dataobject.migration.DoValueMigrationId;
import org.eclipse.scout.rt.dataobject.migration.DoValueMigrationIdsContextData;
import org.eclipse.scout.rt.dataobject.migration.IDoValueMigrationHandler;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class DoValueMigrationDataObjectVisitor
extends AbstractReplacingDataObjectVisitor {
    protected final DoStructureMigrationInventory m_inventory = (DoStructureMigrationInventory)BEANS.get(DoStructureMigrationInventory.class);
    protected final DoStructureMigrationContext m_ctx;
    protected final List<IDoValueMigrationHandler<?>> m_valueMigrationHandlers;
    protected boolean m_changed = false;

    public DoValueMigrationDataObjectVisitor(DoStructureMigrationContext ctx) {
        this.m_ctx = ctx;
        Set<DoValueMigrationId> appliedValueMigrationIds = this.m_ctx.getGlobal(DoValueMigrationIdsContextData.class).getAppliedValueMigrationIds();
        Assertions.assertNotNull(appliedValueMigrationIds, (String)"Applied value migration IDs on context required.", (Object[])new Object[0]);
        this.m_valueMigrationHandlers = this.m_inventory.getValueMigrationHandlers().stream().filter(handler -> !appliedValueMigrationIds.contains(handler.id())).collect(Collectors.toList());
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public <T extends IDataObject> T migrate(T dataObject) {
        if (this.m_valueMigrationHandlers.isEmpty()) {
            return dataObject;
        }
        return this.replaceOrVisit(dataObject);
    }

    protected <T> T replaceOrVisit(T oldValue) {
        if (oldValue == null) {
            return null;
        }
        Object currentValue = oldValue;
        for (IDoValueMigrationHandler<?> handler : this.m_valueMigrationHandlers) {
            if (!handler.valueClass().isInstance(currentValue)) continue;
            Object migratedValue = handler.migrate(this.m_ctx, currentValue);
            this.m_changed |= ObjectUtility.notEquals(currentValue, migratedValue);
            currentValue = migratedValue;
        }
        this.visit(currentValue);
        return currentValue;
    }
}

