/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.security;

import java.security.AccessController;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.cache.AllCacheEntryFilter;
import org.eclipse.scout.rt.platform.cache.ICache;
import org.eclipse.scout.rt.platform.cache.ICacheBuilder;
import org.eclipse.scout.rt.platform.cache.ICacheEntryFilter;
import org.eclipse.scout.rt.platform.cache.ICacheValueResolver;
import org.eclipse.scout.rt.platform.cache.KeyCacheEntryFilter;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.security.IPermissionCollection;
import org.eclipse.scout.rt.security.NonePermissionCollection;

public abstract class AbstractAccessControlService<K>
implements IAccessControlService {
    public static final String ACCESS_CONTROL_SERVICE_CACHE_ID = AbstractAccessControlService.class.getName();
    private volatile Pattern[] m_userIdSearchPatterns = new Pattern[]{Pattern.compile(".*\\\\([^/@]+)"), Pattern.compile(".*\\\\([^/@]+)[/@].*"), Pattern.compile("([^/@]+)"), Pattern.compile("([^/@]+)[/@].*")};
    private volatile ICache<K, IPermissionCollection> m_cache;

    @PostConstruct
    protected void initCache() {
        this.m_cache = this.createCacheBuilder().build();
    }

    protected Pattern[] getUserIdSearchPatterns() {
        return this.m_userIdSearchPatterns;
    }

    protected void setUserIdSearchPatterns(Pattern ... patterns) {
        this.m_userIdSearchPatterns = patterns == null ? new Pattern[0] : patterns;
    }

    protected void setUserIdSearchPatterns(String ... patterns) {
        Pattern[] a = new Pattern[patterns.length];
        int i = 0;
        while (i < a.length) {
            a[i] = Pattern.compile(patterns[i]);
            ++i;
        }
        this.setUserIdSearchPatterns(a);
    }

    protected ICacheBuilder<K, IPermissionCollection> createCacheBuilder() {
        ICacheBuilder cacheBuilder = (ICacheBuilder)BEANS.get(ICacheBuilder.class);
        return cacheBuilder.withCacheId(ACCESS_CONTROL_SERVICE_CACHE_ID).withValueResolver(this.createCacheValueResolver()).withShared(true).withClusterEnabled(true).withTransactional(true).withTransactionalFastForward(true).withTimeToLive(Long.valueOf(1L), TimeUnit.HOURS, false);
    }

    protected ICacheValueResolver<K, IPermissionCollection> createCacheValueResolver() {
        return this::execLoadPermissions;
    }

    protected ICache<K, IPermissionCollection> getCache() {
        return this.m_cache;
    }

    protected abstract K getCurrentUserCacheKey();

    protected abstract IPermissionCollection execLoadPermissions(K var1);

    @Override
    public String getUserIdOfCurrentSubject() {
        return this.getUserId(Subject.getSubject(AccessController.getContext()));
    }

    @Override
    public String getUserId(Subject subject) {
        if (subject == null) {
            return null;
        }
        for (Principal p : subject.getPrincipals()) {
            String name = p.getName().toLowerCase();
            Pattern[] patternArray = this.m_userIdSearchPatterns;
            int n = this.m_userIdSearchPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pat = patternArray[n2];
                Matcher m = pat.matcher(name);
                if (m.matches()) {
                    return m.group(1);
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IPermissionCollection getPermissions() {
        IPermissionCollection permissions = (IPermissionCollection)this.getCache().get(this.getCurrentUserCacheKey());
        return permissions == null ? (IPermissionCollection)BEANS.get(NonePermissionCollection.class) : permissions;
    }

    @Override
    public void clearCache() {
        this.getCache().invalidate((ICacheEntryFilter)new AllCacheEntryFilter(), true);
    }

    @Override
    public void clearCacheOfCurrentUser() {
        this.clearCache(Collections.singleton(this.getCurrentUserCacheKey()));
    }

    protected void clearCache(Collection<? extends K> cacheKeys) {
        if (cacheKeys == null) {
            return;
        }
        KeyCacheEntryFilter filter = new KeyCacheEntryFilter(cacheKeys);
        if (filter.getKeys().isEmpty()) {
            return;
        }
        this.getCache().invalidate((ICacheEntryFilter)filter, true);
    }
}

