/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.security;

import java.security.Permission;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.security.IPermission;
import org.eclipse.scout.rt.security.IPermissionCollection;
import org.eclipse.scout.rt.security.PermissionLevel;

public abstract class AbstractPermission
extends Permission
implements IPermission {
    private static final long serialVersionUID = 1L;
    private IPermissionCollection m_permissionCollection;
    private PermissionLevel m_level;

    public AbstractPermission(String name) {
        super(name);
    }

    protected IPermissionCollection getPermissionCollection() {
        return this.m_permissionCollection;
    }

    @Override
    public final PermissionLevel getLevel() {
        return this.m_level;
    }

    @Override
    public final void setLevelInternal(PermissionLevel level) {
        this.assertInitializing();
        this.m_level = level;
    }

    @Override
    public String getAccessCheckFailedMessage() {
        return TEXTS.get((String)"YouAreNotAuthorizedToPerformThisAction");
    }

    @Override
    public boolean matches(IPermission p) {
        return p != null && p.getClass() == this.getClass() && this.getName().equals(p.getName());
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission instanceof IPermission) {
            return this.implies((IPermission)((Object)permission));
        }
        return false;
    }

    @Override
    public boolean implies(IPermission p) {
        if (this.matches(p) && this.getLevel() != PermissionLevel.NONE) {
            return this.evalPermission(p);
        }
        return false;
    }

    protected boolean evalPermission(IPermission p) {
        return true;
    }

    protected void assertInitializing() {
        Assertions.assertNull((Object)this.m_permissionCollection, (String)"Permission already initialized and can not be modified anymore", (Object[])new Object[0]);
    }

    @Override
    public void assignPermissionCollection(IPermissionCollection permissionCollection) {
        this.assertInitializing();
        this.initialize(permissionCollection);
        this.validate(permissionCollection);
        this.m_permissionCollection = (IPermissionCollection)Assertions.assertNotNull((Object)permissionCollection);
    }

    protected void initialize(IPermissionCollection permissionCollection) {
    }

    protected void validate(IPermissionCollection permissionCollection) {
        this.validateLevel();
    }

    protected void validateLevel() {
        Assertions.assertNotNull((Object)this.m_level, (String)"Granted level is not set on {}", (Object[])new Object[]{this});
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + (this.m_level == null ? 0 : this.m_level.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPermission other = (AbstractPermission)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.m_level == null ? other.m_level != null : !this.m_level.equals(other.m_level));
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [name=" + this.getName() + (this.m_level != null ? ", level=" + this.m_level : "") + "]";
    }
}

