/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.security;

import java.security.Permission;
import java.util.stream.Stream;
import org.eclipse.scout.rt.dataobject.exception.AccessForbiddenException;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.security.IPermission;
import org.eclipse.scout.rt.security.IPermissionCollection;
import org.eclipse.scout.rt.security.PermissionLevel;

@ApplicationScoped
public class AccessSupport {
    public boolean check(Permission p) {
        return ((IAccessControlService)BEANS.get(IAccessControlService.class)).getPermissions().implies(p);
    }

    public void checkAndThrow(Permission p) {
        if (!this.check(p)) {
            throw this.getAccessCheckFailedException(p);
        }
    }

    public boolean checkAny(Permission ... permissions) {
        if (permissions == null) {
            return false;
        }
        IPermissionCollection c = ((IAccessControlService)BEANS.get(IAccessControlService.class)).getPermissions();
        return Stream.of(permissions).anyMatch(c::implies);
    }

    public void checkAnyAndThrow(Permission ... permissions) {
        if (!this.checkAny(permissions)) {
            if (permissions == null || permissions.length == 0) {
                throw this.getDefaultAccessCheckFailedException();
            }
            throw this.getAccessCheckFailedException(permissions[0]);
        }
    }

    public boolean checkAll(Permission ... permissions) {
        if (permissions == null) {
            return false;
        }
        IPermissionCollection c = ((IAccessControlService)BEANS.get(IAccessControlService.class)).getPermissions();
        return Stream.of(permissions).allMatch(c::implies);
    }

    public void checkAllAndThrow(Permission ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw this.getDefaultAccessCheckFailedException();
        }
        IPermissionCollection c = ((IAccessControlService)BEANS.get(IAccessControlService.class)).getPermissions();
        Stream.of(permissions).forEach(p -> {
            if (!c.implies((Permission)p)) {
                throw this.getAccessCheckFailedException((Permission)p);
            }
        });
    }

    public AccessForbiddenException getAccessCheckFailedException(Permission p) {
        if (p instanceof IPermission) {
            return this.getAccessCheckFailedException((IPermission)((Object)p));
        }
        return this.getDefaultAccessCheckFailedException().withContextInfo("permission", (Object)"{}", new Object[]{p});
    }

    protected AccessForbiddenException getAccessCheckFailedException(IPermission p) {
        return new AccessForbiddenException(p.getAccessCheckFailedMessage(), new Object[0]).withContextInfo("permission", (Object)"{}", new Object[]{p});
    }

    public AccessForbiddenException getDefaultAccessCheckFailedException() {
        return new AccessForbiddenException(TEXTS.get((String)"YouAreNotAuthorizedToPerformThisAction"), new Object[0]);
    }

    public PermissionLevel getGrantedPermissionLevel(IPermission permission) {
        return ((IAccessControlService)BEANS.get(IAccessControlService.class)).getPermissions().getGrantedPermissionLevel(permission);
    }
}

