/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.security;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class PermissionLevel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile Map<Integer, PermissionLevel> s_singletonMap = Collections.emptyMap();
    public static final int LEVEL_UNDEFINED = -1;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_ALL = 100;
    public static final PermissionLevel UNDEFINED = PermissionLevel.register(-1, "UNDEFINED", false, () -> TEXTS.get((String)"Undefined"));
    public static final PermissionLevel NONE = PermissionLevel.register(0, "NONE", false, () -> TEXTS.get((String)"None"));
    public static final PermissionLevel ALL = PermissionLevel.register(100, "ALL", true, () -> TEXTS.get((String)"All"));
    private final int m_value;
    private final transient String m_stringValue;
    private transient boolean m_active;
    private transient Supplier<String> m_textSupplier;

    public static PermissionLevel register(int value, String stringValue, boolean active, Supplier<String> textSupplier) {
        return PermissionLevel.register(value, stringValue, active, textSupplier, false);
    }

    public static void registerOrOverride(int value, String stringValue, boolean active, Supplier<String> textSupplier) {
        PermissionLevel.register(value, stringValue, active, textSupplier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PermissionLevel register(int value, String stringValue, boolean active, Supplier<String> textSupplier, boolean override) {
        Class<PermissionLevel> clazz = PermissionLevel.class;
        synchronized (PermissionLevel.class) {
            PermissionLevel permissionLevel = s_singletonMap.get(value);
            if (permissionLevel == null) {
                permissionLevel = new PermissionLevel(value, stringValue, active, textSupplier);
                HashMap<Integer, PermissionLevel> map = new HashMap<Integer, PermissionLevel>(s_singletonMap);
                map.put(value, permissionLevel);
                s_singletonMap = map;
            } else if (override) {
                permissionLevel.setActive(active);
                permissionLevel.setTextSupplier(textSupplier);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return permissionLevel;
        }
    }

    public static PermissionLevel get(int value) {
        return (PermissionLevel)Assertions.assertNotNull((Object)PermissionLevel.opt(value), (String)"There is no PermissionLevel {} registered", (Object[])new Object[]{value});
    }

    public static PermissionLevel opt(int value) {
        return s_singletonMap.get(value);
    }

    public static Set<PermissionLevel> all() {
        return new HashSet<PermissionLevel>(s_singletonMap.values());
    }

    private PermissionLevel(int value, String stringValue, boolean active, Supplier<String> textSupplier) {
        this.m_value = value;
        this.m_stringValue = Assertions.assertNotNullOrEmpty((String)stringValue);
        this.m_active = active;
        this.m_textSupplier = (Supplier)Assertions.assertNotNull(textSupplier);
    }

    public int getValue() {
        return this.m_value;
    }

    public String getStringValue() {
        return this.m_stringValue;
    }

    public boolean isActive() {
        return this.m_active;
    }

    private void setActive(boolean active) {
        this.m_active = active;
    }

    public String getText() {
        return this.m_textSupplier.get();
    }

    private void setTextSupplier(Supplier<String> textSupplier) {
        this.m_textSupplier = (Supplier)Assertions.assertNotNull(textSupplier);
    }

    private Object readResolve() throws ObjectStreamException {
        PermissionLevel existing = PermissionLevel.opt(this.m_value);
        if (existing == null) {
            return PermissionLevel.register(this.m_value, "UNKNOWN[" + this.m_value + "]", false, () -> "Unknown PermssionLevel");
        }
        return existing;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.m_value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PermissionLevel other = (PermissionLevel)obj;
        return this.m_value == other.m_value;
    }

    public String toString() {
        return this.m_stringValue;
    }
}

