/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.config.AbstractBooleanConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractMapConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractStringListConfigProperty;
import org.eclipse.scout.rt.platform.config.ConfigUtility;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.healthcheck.RemoteHealthChecker;
import org.eclipse.scout.rt.server.commons.servlet.ContentSecurityPolicy;

public final class ServerCommonsConfigProperties {
    private ServerCommonsConfigProperties() {
    }

    public static class CspDirectiveProperty
    extends AbstractMapConfigProperty {
        public String getKey() {
            return "scout.cspDirective";
        }

        public String description() {
            return String.format("Configures individual Content Security Policy (CSP) directives.\nSee https://www.w3.org/TR/CSP2/ and the Bean '%s' for more details.\nThe value must be provided as a Map.\nExample: scout.cspDirective[img-src]='self' data: https: http://localhost:8086", ContentSecurityPolicy.class.getName());
        }
    }

    public static class CspEnabledProperty
    extends AbstractBooleanConfigProperty {
        public Boolean getDefaultValue() {
            return true;
        }

        public String description() {
            return String.format("Enable or disable Content Security Policy (CSP) headers. The headers can be modified by replacing the bean '%s' or using the property '%s'.", ContentSecurityPolicy.class.getName(), ((CspDirectiveProperty)((Object)BEANS.get(CspDirectiveProperty.class))).getKey());
        }

        public String getKey() {
            return "scout.cspEnabled";
        }
    }

    public static class CspExclusionsProperty
    extends AbstractConfigProperty<List<Pattern>, List<String>> {
        public String getKey() {
            return "scout.cspExclusions";
        }

        public List<String> readFromSource(String namespace) {
            return ConfigUtility.getPropertyList((String)this.getKey(), null, (String)namespace);
        }

        protected List<Pattern> parse(List<String> value) {
            if (value == null) {
                return null;
            }
            return value.stream().filter(Objects::nonNull).map(Pattern::compile).collect(Collectors.toList());
        }

        public String description() {
            return String.format("A list of regex strings. If the pathInfo of the request matches one of these strings the csp headers won't be set. This property only has an effect if csp is enabled, see '%s'.", ((CspEnabledProperty)((Object)BEANS.get(CspEnabledProperty.class))).getKey());
        }
    }

    public static class RemoteHealthCheckUrlsProperty
    extends AbstractConfigProperty<List<String>, String> {
        public String getKey() {
            return "scout.healthCheckRemoteUrls";
        }

        public String description() {
            return String.format("Comma separated list of URLs the '%s' should access.\nBy default no URLs are set.", RemoteHealthChecker.class.getSimpleName());
        }

        protected List<String> parse(String value) {
            String[] tokens = StringUtility.tokenize((String)value, (char)',');
            return Collections.unmodifiableList(Arrays.asList(tokens));
        }

        public List<String> getDefaultValue() {
            return Collections.emptyList();
        }
    }

    public static class TrustedCertificatesProperty
    extends AbstractStringListConfigProperty {
        public String getKey() {
            return "scout.trustedCertificates";
        }

        public String description() {
            return "URIs to DER (Base64) encoded certificate files that should be trusted. The URI may refer to a local file or a resource on the classpath (use classpath: prefix). The default value is an empty list.";
        }
    }

    public static class UrlHintsEnabledProperty
    extends AbstractBooleanConfigProperty {
        public Boolean getDefaultValue() {
            return Platform.get().inDevelopmentMode();
        }

        public String description() {
            return String.format("Enable or disable changing UrlHints using URL parameters in the browser address line.\nBy default has the same value as the config property '%s' meaning it is by default only enabled in development mode.", ((PlatformConfigProperties.PlatformDevModeProperty)BEANS.get(PlatformConfigProperties.PlatformDevModeProperty.class)).getKey());
        }

        public String getKey() {
            return "scout.urlHints.enabled";
        }
    }
}

