/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.IBeanManager;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.context.PlatformIdentifier;

public class WebappEventListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        ServletContextRegistration.servletContext = servletContext;
        PlatformIdentifier.set((String)servletContext.getContextPath());
        IPlatform platform = Platform.get();
        platform.awaitPlatformStarted();
        if (BEANS.opt(ServletContext.class) == null) {
            WebappEventListener.registerServletContext(BEANS.getBeanManager(), servletContext);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContextRegistration.servletContext = null;
        IPlatform platform = Platform.peek();
        if (platform != null && platform.getState() != IPlatform.State.PlatformStopped) {
            platform.stop();
        }
    }

    protected static void registerServletContext(IBeanManager manager, ServletContext servletContext) {
        manager.registerBean(new BeanMetaData(ServletContext.class, (Object)servletContext).withApplicationScoped(true));
    }

    public static final class ServletContextRegistration
    implements IPlatformListener {
        private static volatile ServletContext servletContext;

        public void stateChanged(PlatformEvent event) {
            switch (event.getState()) {
                case BeanManagerPrepared: {
                    WebappEventListener.registerServletContext(event.getSource().getBeanManager(), servletContext);
                }
            }
        }

        static /* synthetic */ ServletContext access$1() {
            return servletContext;
        }
    }
}

