/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.security.IPrincipalProducer;
import org.eclipse.scout.rt.server.commons.authentication.AnonymousAccessController;
import org.eclipse.scout.rt.server.commons.authentication.IAccessController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class DevelopmentAccessController
implements IAccessController {
    private static final Logger LOG = LoggerFactory.getLogger(DevelopmentAccessController.class);
    private final AnonymousAccessController m_anonymousAccessController = (AnonymousAccessController)BEANS.get(AnonymousAccessController.class);
    private final AnonymousAccessController.AnonymousAuthConfig m_config = new AnonymousAccessController.AnonymousAuthConfig();
    private final AtomicBoolean m_warningLogged = new AtomicBoolean(false);

    public DevelopmentAccessController init() {
        this.init(new DevelopmentAuthConfig());
        return this;
    }

    public DevelopmentAccessController init(DevelopmentAuthConfig config) {
        AnonymousAccessController.AnonymousAuthConfig anonymousAuthConfig = this.m_config.withEnabled(config.isEnabled() && Platform.get().inDevelopmentMode()).withUsername(System.getProperty("user.name")).withPutPrincipalOnSession(config.isPutPrincipalOnSession());
        if (config.getPrincipalProducer() != null) {
            anonymousAuthConfig.withPrincipalProducer(config.getPrincipalProducer());
        }
        this.m_anonymousAccessController.init(anonymousAuthConfig);
        return this;
    }

    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.m_config.isEnabled() && this.m_warningLogged.compareAndSet(false, true)) {
            LOG.warn("+++ Development access control with user {}", (Object)this.m_config.getUsername());
        }
        return this.m_anonymousAccessController.handle(request, response, chain);
    }

    @Override
    public void destroy() {
        this.m_anonymousAccessController.destroy();
    }

    public static class DevelopmentAuthConfig {
        private boolean m_enabled = true;
        private IPrincipalProducer m_principalProducer = null;
        private boolean m_putPrincipalOnSession = true;

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public DevelopmentAuthConfig withEnabled(boolean enabled) {
            this.m_enabled = enabled;
            return this;
        }

        public IPrincipalProducer getPrincipalProducer() {
            return this.m_principalProducer;
        }

        public DevelopmentAuthConfig withPrincipalProducer(IPrincipalProducer principalProducer) {
            this.m_principalProducer = principalProducer;
            return this;
        }

        public boolean isPutPrincipalOnSession() {
            return this.m_putPrincipalOnSession;
        }

        public DevelopmentAuthConfig withPutPrincipalOnSession(boolean putPrincipalOnSession) {
            this.m_putPrincipalOnSession = putPrincipalOnSession;
            return this;
        }
    }
}

