/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import java.io.IOException;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.security.ICredentialVerifier;
import org.eclipse.scout.rt.platform.security.IPrincipalProducer;
import org.eclipse.scout.rt.platform.security.SimplePrincipalProducer;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.SleepUtil;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.authentication.IAccessController;
import org.eclipse.scout.rt.server.commons.authentication.ServletFilterHelper;

public class FormBasedAccessController
implements IAccessController {
    protected FormBasedAuthConfig m_config;

    public FormBasedAccessController init(FormBasedAuthConfig config) {
        this.m_config = config;
        Assertions.assertNotNull((Object)this.m_config.getCredentialVerifier(), (String)"CredentialVerifier must not be null", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)this.m_config.getPrincipalProducer(), (String)"PrincipalProducer must not be null", (Object[])new Object[0]);
        return this;
    }

    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.m_config.isEnabled()) {
            return false;
        }
        if ("/auth".equals(request.getPathInfo())) {
            return this.handleAuthRequest(request, response);
        }
        return false;
    }

    @Override
    public void destroy() {
    }

    protected boolean handleAuthRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setHeader("Cache-Control", "private, no-store, no-cache, max-age=0");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        Pair<String, char[]> credentials = this.readCredentials(request);
        if (credentials == null) {
            this.handleForbidden(8, response);
            return true;
        }
        int status = this.m_config.getCredentialVerifier().verify((String)credentials.getLeft(), (char[])credentials.getRight());
        if (status != 1) {
            this.handleForbidden(status, response);
            return true;
        }
        ServletFilterHelper helper = (ServletFilterHelper)BEANS.get(ServletFilterHelper.class);
        helper.invalidateSessionAfterLogin(request);
        Principal principal = this.m_config.getPrincipalProducer().produce((String)credentials.getLeft());
        helper.putPrincipalOnSession(request, principal);
        return true;
    }

    protected void handleForbidden(int status, HttpServletResponse response) throws IOException {
        if (this.m_config.getStatus403WaitMillis() > 0L) {
            SleepUtil.sleepSafe((long)this.m_config.getStatus403WaitMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        response.sendError(403);
    }

    protected Pair<String, char[]> readCredentials(HttpServletRequest request) {
        String user = request.getParameter("user");
        if (StringUtility.isNullOrEmpty((CharSequence)user)) {
            return null;
        }
        String password = request.getParameter("password");
        if (StringUtility.isNullOrEmpty((CharSequence)password)) {
            return null;
        }
        return new ImmutablePair((Object)user, (Object)password.toCharArray());
    }

    public static class FormBasedAuthConfig {
        private boolean m_enabled = true;
        private long m_status403WaitMillis = 500L;
        private ICredentialVerifier m_credentialVerifier;
        private IPrincipalProducer m_principalProducer = (IPrincipalProducer)BEANS.get(SimplePrincipalProducer.class);

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public FormBasedAuthConfig withEnabled(boolean enabled) {
            this.m_enabled = enabled;
            return this;
        }

        public ICredentialVerifier getCredentialVerifier() {
            return this.m_credentialVerifier;
        }

        public FormBasedAuthConfig withCredentialVerifier(ICredentialVerifier credentialVerifier) {
            this.m_credentialVerifier = credentialVerifier;
            return this;
        }

        public IPrincipalProducer getPrincipalProducer() {
            return this.m_principalProducer;
        }

        public FormBasedAuthConfig withPrincipalProducer(IPrincipalProducer principalProducer) {
            this.m_principalProducer = principalProducer;
            return this;
        }

        public long getStatus403WaitMillis() {
            return this.m_status403WaitMillis;
        }

        public FormBasedAuthConfig withStatus403WaitMillis(long waitMillis) {
            this.m_status403WaitMillis = waitMillis;
            return this;
        }
    }
}

