/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import java.io.IOException;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.security.ConfigFileCredentialVerifier;
import org.eclipse.scout.rt.platform.security.ICredentialVerifier;
import org.eclipse.scout.rt.platform.security.IPrincipalProducer;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.SleepUtil;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.authentication.IAccessController;
import org.eclipse.scout.rt.server.commons.authentication.ServletFilterHelper;

@Bean
public class HttpBasicAuthAccessController
implements IAccessController {
    protected HttpBasicAuthConfig m_config;

    public HttpBasicAuthAccessController init() {
        return this.init(new HttpBasicAuthConfig());
    }

    public HttpBasicAuthAccessController init(HttpBasicAuthConfig config) {
        this.m_config = config;
        Assertions.assertNotNull((Object)this.m_config.getCredentialVerifier(), (String)"CredentialVerifier must not be null", (Object[])new Object[0]);
        return this;
    }

    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.m_config.isEnabled()) {
            return false;
        }
        return this.handleInternal(request, response, chain);
    }

    @Override
    public void destroy() {
    }

    protected boolean handleInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        Pair<String, char[]> credentials = this.readCredentials(request);
        if (credentials == null) {
            this.handleForbidden(8, response);
            return true;
        }
        int status = this.m_config.getCredentialVerifier().verify((String)credentials.getLeft(), (char[])credentials.getRight());
        if (status != 1) {
            this.handleForbidden(status, response);
            return true;
        }
        if (this.m_config.getPrincipalProducer() != null) {
            Principal principal = this.m_config.getPrincipalProducer().produce((String)credentials.getLeft());
            ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).continueChainAsSubject(principal, request, response, chain);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        return true;
    }

    protected void handleForbidden(int status, HttpServletResponse resp) throws IOException {
        if (status == 8) {
            resp.addHeader("WWW-Authenticate", "Basic");
            resp.sendError(401);
        } else {
            if (this.m_config.getStatus403WaitMillis() > 0L) {
                SleepUtil.sleepSafe((long)this.m_config.getStatus403WaitMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            resp.sendError(403);
        }
    }

    protected Pair<String, char[]> readCredentials(HttpServletRequest req) {
        String[] basicCredentials = ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).parseBasicAuthRequest(req);
        if (basicCredentials == null || basicCredentials.length != 2) {
            return null;
        }
        String user = basicCredentials[0];
        if (StringUtility.isNullOrEmpty((CharSequence)user)) {
            return null;
        }
        String password = basicCredentials[1];
        if (StringUtility.isNullOrEmpty((CharSequence)password)) {
            return null;
        }
        return new ImmutablePair((Object)user, (Object)password.toCharArray());
    }

    public static class HttpBasicAuthConfig {
        private boolean m_enabled = true;
        private ICredentialVerifier m_credentialVerifier = (ICredentialVerifier)BEANS.get(ConfigFileCredentialVerifier.class);
        private IPrincipalProducer m_principalProducer = null;
        private long m_status403WaitMillis = 500L;

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public HttpBasicAuthConfig withEnabled(boolean enabled) {
            this.m_enabled = enabled;
            return this;
        }

        public ICredentialVerifier getCredentialVerifier() {
            return this.m_credentialVerifier;
        }

        public HttpBasicAuthConfig withCredentialVerifier(ICredentialVerifier credentialVerifier) {
            this.m_credentialVerifier = credentialVerifier;
            return this;
        }

        public IPrincipalProducer getPrincipalProducer() {
            return this.m_principalProducer;
        }

        public HttpBasicAuthConfig withPrincipalProducer(IPrincipalProducer principalProducer) {
            this.m_principalProducer = principalProducer;
            return this;
        }

        public long getStatus403WaitMillis() {
            return this.m_status403WaitMillis;
        }

        public HttpBasicAuthConfig withStatus403WaitMillis(long waitMillis) {
            this.m_status403WaitMillis = waitMillis;
            return this;
        }
    }
}

