/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.healthcheck;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.server.commons.healthcheck.IHealthChecker;
import org.eclipse.scout.rt.server.commons.servlet.AbstractHttpServlet;
import org.eclipse.scout.rt.server.commons.servlet.ServletExceptionTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHealthCheckServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHealthCheckServlet.class);

    protected abstract RunContext execCreateRunContext();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RunContext context;
        this.disableCaching(req, resp);
        try {
            context = this.execCreateRunContext();
            if (context == null) {
                throw new IllegalArgumentException("context must not be null");
            }
        }
        catch (Throwable t) {
            LOG.error("Creating RunContext failed", t);
            throw ((ServletExceptionTranslator)BEANS.get(ServletExceptionTranslator.class)).translate(t);
        }
        try {
            this.doChecks(context, req, resp);
        }
        catch (Throwable t) {
            LOG.error("HealthChecking crashed", t);
            throw ((ServletExceptionTranslator)BEANS.get(ServletExceptionTranslator.class)).translate(t);
        }
    }

    protected void disableCaching(HttpServletRequest req, HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "private, no-store, no-cache, max-age=0");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
    }

    protected boolean execAcceptCheck(IHealthChecker check) {
        return check.isActive();
    }

    protected void doChecks(RunContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        List<IHealthChecker> checks = this.getActiveHealthCheckers();
        ArrayList<IHealthChecker> failed = new ArrayList<IHealthChecker>();
        for (IHealthChecker check : checks) {
            try {
                if (check.checkHealth(context)) continue;
                failed.add(check);
            }
            catch (Throwable t) {
                LOG.error("HealthChecker[{}] failed", (Object)check.getName(), (Object)t);
                failed.add(check);
            }
        }
        int statusCode = failed.isEmpty() ? 200 : 503;
        String output = this.generateOutput(statusCode, checks, failed, false);
        resp.setContentType("text/plain");
        resp.setStatus(statusCode);
        if (LOG.isDebugEnabled() || Platform.get().inDevelopmentMode()) {
            String detailedOutput = this.generateOutput(statusCode, checks, failed, true);
            LOG.debug(detailedOutput);
            resp.getWriter().print(Platform.get().inDevelopmentMode() ? detailedOutput : output);
        } else {
            resp.getWriter().print(output);
        }
    }

    protected List<IHealthChecker> getActiveHealthCheckers() {
        List all = BEANS.all(IHealthChecker.class);
        ArrayList<IHealthChecker> actives = new ArrayList<IHealthChecker>(all.size());
        for (IHealthChecker check : all) {
            try {
                if (this.execAcceptCheck(check)) {
                    actives.add(check);
                    continue;
                }
                LOG.debug("HealthChecker[{}] was ignored", (Object)check.getName());
            }
            catch (Throwable t) {
                LOG.error("Active-check crashed with HealthChecker[{}]", (Object)check.getName(), (Object)t);
            }
        }
        return Collections.unmodifiableList(actives);
    }

    protected String generateOutput(int statusCode, List<IHealthChecker> checks, List<IHealthChecker> failed, boolean includeDetails) {
        StringBuilder buf = new StringBuilder();
        buf.append(statusCode);
        buf.append(' ');
        buf.append(failed.isEmpty() ? "OK" : "SERVICE_UNAVAILABLE");
        if (includeDetails) {
            for (IHealthChecker check : checks) {
                buf.append('\n');
                buf.append(check.getName());
                buf.append(':');
                buf.append(failed.contains(check) ? "ERROR" : "OK");
            }
        }
        return buf.toString();
    }
}

