/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.healthcheck;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.server.commons.ServerCommonsConfigProperties;
import org.eclipse.scout.rt.server.commons.healthcheck.AbstractHealthChecker;
import org.eclipse.scout.rt.shared.http.DefaultHttpTransportManager;

public class RemoteHealthChecker
extends AbstractHealthChecker {
    private final List<String> m_remoteUrls = (List)((ServerCommonsConfigProperties.RemoteHealthCheckUrlsProperty)((Object)BEANS.get(ServerCommonsConfigProperties.RemoteHealthCheckUrlsProperty.class))).getValue();

    @Override
    protected long getConfiguredTimeoutMillis() {
        return TimeUnit.SECONDS.toMillis(30L);
    }

    @Override
    public boolean isActive() {
        return !CollectionUtility.isEmpty(this.m_remoteUrls);
    }

    @Override
    protected boolean execCheckHealth() throws Exception {
        boolean status = true;
        if (this.m_remoteUrls != null) {
            for (String remote : this.m_remoteUrls) {
                GenericUrl remoteUrl = remote != null ? new GenericUrl(remote) : null;
                HttpRequest req = ((DefaultHttpTransportManager)BEANS.get(DefaultHttpTransportManager.class)).getHttpRequestFactory().buildHeadRequest(remoteUrl);
                req.getHeaders().setCacheControl("no-cache");
                HttpResponse resp = req.execute();
                int statusCode = resp.getStatusCode();
                if (statusCode >= 200 && statusCode < 400) continue;
                status = false;
                break;
            }
        }
        return status;
    }
}

