/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.exception.PlatformException;

public abstract class AbstractHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.wrap(req, resp, (httpServletRequest, httpServletResponse) -> super.service(httpServletRequest, httpServletResponse));
    }

    protected void wrap(HttpServletRequest req, HttpServletResponse resp, HttpServletConsumer consumer) throws ServletException, IOException {
        P_HttpInvocationHandler requestProxyHandler = new P_HttpInvocationHandler(req);
        P_HttpInvocationHandler responseProxyHandler = new P_HttpInvocationHandler(resp);
        try {
            HttpServletRequest request = (HttpServletRequest)Proxy.newProxyInstance(HttpServletRequest.class.getClassLoader(), new Class[]{HttpServletRequest.class}, (InvocationHandler)requestProxyHandler);
            HttpServletResponse response = (HttpServletResponse)Proxy.newProxyInstance(HttpServletResponse.class.getClassLoader(), new Class[]{HttpServletResponse.class}, (InvocationHandler)responseProxyHandler);
            consumer.service(request, response);
        }
        finally {
            requestProxyHandler.invalidate();
            responseProxyHandler.invalidate();
        }
    }

    @FunctionalInterface
    protected static interface HttpServletConsumer {
        public void service(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;
    }

    private final class P_HttpInvocationHandler
    implements InvocationHandler {
        private boolean m_valid = true;
        private final Object m_origin;

        public P_HttpInvocationHandler(Object origin) {
            this.m_origin = origin;
        }

        private void invalidate() {
            this.m_valid = false;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.m_valid) {
                throw new PlatformException("Access to '{}' is not allowed because {} is no longer valid (request has been completed).", new Object[]{method, this.m_origin instanceof HttpServletRequest ? "HTTP servlet request" : "HTTP servlet response"});
            }
            return method.invoke(this.m_origin, args);
        }
    }
}

