/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;

public final class HttpCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String m_resourcePath;
    private final Map<String, String> m_attributes;

    public HttpCacheKey(String resourcePath) {
        this(resourcePath, null);
    }

    public HttpCacheKey(String resourcePath, Map<String, String> attributes) {
        this.m_resourcePath = resourcePath;
        this.m_attributes = attributes != null && !attributes.isEmpty() ? new HashMap<String, String>(attributes) : null;
    }

    public String getResourcePath() {
        return this.m_resourcePath;
    }

    public String getAttribute(String key) {
        return this.m_attributes != null ? this.m_attributes.get(key) : null;
    }

    public int hashCode() {
        return (this.m_resourcePath != null ? this.m_resourcePath.hashCode() : 0) + (this.m_attributes != null ? this.m_attributes.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpCacheKey other = (HttpCacheKey)obj;
        return ObjectUtility.equals((Object)this.m_resourcePath, (Object)other.m_resourcePath) && ObjectUtility.equals(this.m_attributes, other.m_attributes);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, false).attr("resourcePath", this.m_resourcePath).attr("attributes", this.m_attributes).toString();
    }
}

