/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheKey;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheObject;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResourceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class HttpResourceCache
implements IHttpResourceCache {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResourceCache.class);
    private final Map<HttpCacheKey, HttpCacheObject> m_cache = Collections.synchronizedMap(new HashMap());

    @Override
    public boolean put(HttpCacheObject obj) {
        if (!obj.isCachingAllowed()) {
            return false;
        }
        this.m_cache.put(obj.getCacheKey(), obj);
        LOG.debug("Stored object in cache: {}", (Object)obj.getCacheKey());
        return true;
    }

    @Override
    public HttpCacheObject get(HttpCacheKey cacheKey) {
        HttpCacheObject obj = this.m_cache.get(cacheKey);
        LOG.debug("Lookup object in cache: {} found={}", (Object)cacheKey, (Object)(obj != null ? 1 : 0));
        return obj;
    }

    @Override
    public HttpCacheObject remove(HttpCacheKey cacheKey) {
        HttpCacheObject obj = this.m_cache.remove(cacheKey);
        LOG.debug("Remove object in cache: {} removed={}", (Object)cacheKey, (Object)(obj != null ? 1 : 0));
        return obj;
    }

    @Override
    public void clear() {
        LOG.debug("Clear resource cache");
        this.m_cache.clear();
    }
}

