/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.filter.gzip;

import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.UrlHints;
import org.eclipse.scout.rt.server.commons.servlet.filter.gzip.GzipServletRequestWrapper;
import org.eclipse.scout.rt.server.commons.servlet.filter.gzip.GzipServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipServletFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(GzipServletFilter.class);
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String GZIP = "gzip";
    public static final String CONTENT_TYPES = "text/html,text/css,text/xml,text/plain,application/json,application/javascript,image/svg+xml,text/vcard";
    private int m_getMinSize;
    private int m_postMinSize;
    private Set<String> m_contentTypes;

    public void init(FilterConfig config) throws ServletException {
        this.m_getMinSize = Integer.parseInt((String)ObjectUtility.nvl((Object)config.getInitParameter("get_min_size"), (Object)"256"));
        this.m_postMinSize = Integer.parseInt((String)ObjectUtility.nvl((Object)config.getInitParameter("post_min_size"), (Object)"256"));
        this.m_contentTypes = CollectionUtility.hashSet((Object[])StringUtility.split((String)((String)ObjectUtility.nvl((Object)config.getInitParameter("content_types"), (Object)CONTENT_TYPES)), (String)","));
    }

    public void doFilter(ServletRequest req0, ServletResponse resp0, FilterChain chain) throws IOException, ServletException {
        Object req = (HttpServletRequest)req0;
        Object resp = (HttpServletResponse)resp0;
        if (this.requestHasGzipEncoding((HttpServletRequest)req)) {
            GzipServletRequestWrapper gzipReq = new GzipServletRequestWrapper((HttpServletRequest)req);
            req = gzipReq;
            if (LOG.isDebugEnabled()) {
                LOG.debug("GZIP request[size {}%, compressed: {}, uncompressed: {}]: {}", new Object[]{gzipReq.getCompressedLength() * 100 / gzipReq.getUncompressedLength(), gzipReq.getCompressedLength(), gzipReq.getUncompressedLength(), req.getPathInfo()});
            }
        }
        if (this.requestAcceptsGzipEncoding((HttpServletRequest)req)) {
            resp = new GzipServletResponseWrapper((HttpServletResponse)resp);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        if (resp instanceof GzipServletResponseWrapper) {
            boolean compressed;
            GzipServletResponseWrapper gzipResp = (GzipServletResponseWrapper)((Object)resp);
            int minLength = this.minimumLengthToCompress((HttpServletRequest)req);
            if (!this.responseNeedsGzipEncoding((HttpServletRequest)req, (HttpServletResponse)resp)) {
                minLength = -1;
            }
            if ((compressed = gzipResp.finish(minLength)) && LOG.isDebugEnabled()) {
                LOG.debug("GZIP response[size {}%, uncompressed: {}, compressed: {}]: {}", new Object[]{gzipResp.getCompressedLength() * 100 / gzipResp.getUncompressedLength(), gzipResp.getUncompressedLength(), gzipResp.getCompressedLength(), req.getPathInfo()});
            }
        }
    }

    protected boolean requestHasGzipEncoding(HttpServletRequest req) {
        String h = req.getHeader(CONTENT_ENCODING);
        return h != null && h.contains(GZIP);
    }

    protected boolean requestAcceptsGzipEncoding(HttpServletRequest req) {
        String h = req.getHeader(ACCEPT_ENCODING);
        return h != null && h.contains(GZIP);
    }

    protected boolean responseNeedsGzipEncoding(HttpServletRequest req, HttpServletResponse resp) {
        if (!UrlHints.isCompressHint(req)) {
            return false;
        }
        String contentType = resp.getContentType();
        if (contentType == null) {
            return false;
        }
        return this.m_contentTypes.contains(contentType = contentType.split(";")[0]);
    }

    protected int minimumLengthToCompress(HttpServletRequest req) {
        if ("GET".equals(req.getMethod())) {
            return this.m_getMinSize;
        }
        if ("POST".equals(req.getMethod())) {
            return this.m_postMinSize;
        }
        return -1;
    }

    public void destroy() {
    }
}

