/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.eclipse.scout.rt.platform.util.Assertions;

public class BufferedServletOutputStream
extends ServletOutputStream {
    private final ByteArrayOutputStream m_buf = new ByteArrayOutputStream();
    private volatile Object m_writeListener;

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
        this.m_writeListener = Assertions.assertNotNull((Object)writeListener);
        try {
            writeListener.onWritePossible();
        }
        catch (IOException e) {
            writeListener.onError((Throwable)e);
        }
    }

    public void write(byte[] b) throws IOException {
        try {
            this.m_buf.write(b);
        }
        catch (IOException e) {
            WriteListener listener = (WriteListener)this.m_writeListener;
            if (listener != null) {
                listener.onError((Throwable)e);
            }
            throw e;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.m_buf.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.m_buf.write(b);
    }

    public byte[] getContent() {
        return this.m_buf.toByteArray();
    }
}

