/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpSessionMutex
implements HttpSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSessionMutex.class);
    public static final String SESSION_MUTEX_ATTRIBUTE_NAME = "scout.httpsession.mutex";

    private void initMutex(HttpSession httpSession) {
        ((HttpSession)Assertions.assertNotNull((Object)httpSession)).setAttribute(SESSION_MUTEX_ATTRIBUTE_NAME, new Object());
        LOG.debug("Prepared new HTTP session {}", (Object)httpSession.getId());
    }

    public static Object of(HttpSession httpSession) {
        Object mutex = ((HttpSession)Assertions.assertNotNull((Object)httpSession)).getAttribute(SESSION_MUTEX_ATTRIBUTE_NAME);
        if (mutex != null) {
            return mutex;
        }
        LOG.info("Session without mutex: {}. Consider registering {} as listener in the web.xml", new Object[]{httpSession.getId(), HttpSessionMutex.class, new Exception("origin")});
        return httpSession;
    }

    public void sessionCreated(HttpSessionEvent event) {
        this.initMutex(event.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }
}

