/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.idempotent;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.LongPredicate;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.date.IDateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceNumberDuplicateDetector
implements LongPredicate {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceNumberDuplicateDetector.class);
    private final TreeMap<Long, Long> m_cache = new TreeMap();
    private final int m_cacheSizeGuide;
    private final long m_maxAgeMillis;
    private final boolean m_acceptPotentialDuplicates;

    public SequenceNumberDuplicateDetector() {
        this(25, 1L, TimeUnit.MINUTES);
    }

    public SequenceNumberDuplicateDetector(int cacheSizeGuide, long maxAge, TimeUnit maxAgeUnit) {
        this(cacheSizeGuide, maxAge, maxAgeUnit, true);
    }

    public SequenceNumberDuplicateDetector(int cacheSizeGuide, long maxAge, TimeUnit maxAgeUnit, boolean acceptPotentialDuplicates) {
        Assertions.assertTrue((cacheSizeGuide >= 1 ? 1 : 0) != 0, (String)"cacheSizeGuide ({}) must be at least 1", (Object[])new Object[0]);
        Assertions.assertTrue((cacheSizeGuide < 0x2AAAAAAA ? 1 : 0) != 0, (String)"cacheSizeGuide ({}) must be at most {}715827882", (Object[])new Object[0]);
        this.m_cacheSizeGuide = cacheSizeGuide;
        this.m_maxAgeMillis = maxAgeUnit.toMillis(maxAge);
        this.m_acceptPotentialDuplicates = acceptPotentialDuplicates;
    }

    @Override
    public boolean test(long value) {
        return this.accept(value);
    }

    public synchronized boolean accept(long n) {
        if (this.m_cache.containsKey(n)) {
            return false;
        }
        long now = ((IDateProvider)BEANS.get(IDateProvider.class)).currentUTCMillis();
        if (this.m_cache.size() >= this.m_cacheSizeGuide && n < this.m_cache.firstKey()) {
            LOG.warn("Potential duplicate request id {}. The cache size is {}, the window is {}, {}. Assuming new key is {}.", new Object[]{n, this.m_cache.size(), this.m_cache.firstKey(), this.m_cache.lastKey(), this.m_acceptPotentialDuplicates ? "valid" : "invalid"});
            if (!this.m_acceptPotentialDuplicates) {
                return false;
            }
        }
        this.m_cache.put(n, now);
        if (this.m_cache.size() > this.m_cacheSizeGuide * 2) {
            while (this.m_cache.size() > this.m_cacheSizeGuide) {
                long age = now - this.m_cache.firstEntry().getValue();
                if (age <= this.m_maxAgeMillis) break;
                this.m_cache.pollFirstEntry();
            }
        }
        return true;
    }

    protected TreeMap<Long, Long> getCache() {
        return this.m_cache;
    }
}

