/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.cache;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.server.commons.servlet.UrlHints;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HttpCacheControl {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCacheControl.class);
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final int IF_MODIFIED_SINCE_FIDELITY = 999;
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String ETAG = "ETag";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final int MAX_AGE_ONE_YEAR = 31536000;
    public static final int MAX_AGE_4_HOURS = 14400;
    public static final int MAX_AGE_NONE = 0;

    public boolean checkAndSetCacheHeaders(HttpServletRequest req, HttpServletResponse resp, HttpCacheObject obj) {
        boolean clientSentEtag;
        if (!UrlHints.isCacheHint(req)) {
            this.disableCaching(req, resp);
            return false;
        }
        if (obj == null || !obj.isCachingAllowed()) {
            this.disableCaching(req, resp);
            return false;
        }
        int maxAge = obj.getCacheMaxAge();
        if (maxAge > 0) {
            resp.setHeader(CACHE_CONTROL, "private, max-age=" + maxAge + ", s-maxage=" + maxAge);
        } else {
            resp.setHeader(CACHE_CONTROL, "private, max-age=0, must-revalidate");
        }
        String etag = obj.createETag();
        String ifNoneMatch = req.getHeader(IF_NONE_MATCH);
        boolean bl = clientSentEtag = ifNoneMatch != null;
        if (clientSentEtag) {
            if (this.notModified(ifNoneMatch, etag)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Use http cached object (If-None-Match/Etag): {}", (Object)req.getPathInfo());
                }
                resp.setStatus(304);
                return true;
            }
        } else {
            long ifModifiedSince = req.getDateHeader(IF_MODIFIED_SINCE);
            if (this.notModifiedSince(ifModifiedSince, obj.getResource().getLastModified())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Use http cached object (If-Modified-Since): {}", (Object)req.getPathInfo());
                }
                resp.setStatus(304);
                return true;
            }
        }
        if (obj.getResource().getLastModified() > 0L) {
            resp.setDateHeader(LAST_MODIFIED, obj.getResource().getLastModified());
        }
        if (etag != null) {
            resp.setHeader(ETAG, etag);
        }
        return false;
    }

    protected void disableCaching(HttpServletRequest req, HttpServletResponse resp) {
        resp.setHeader(CACHE_CONTROL, "private, no-store, no-cache, max-age=0");
    }

    protected boolean notModified(String ifNoneMatch, String etag) {
        return ifNoneMatch != null && etag != null && ifNoneMatch.contains(etag);
    }

    protected boolean notModifiedSince(long ifModifiedSince, long lastModified) {
        return ifModifiedSince > -1L && lastModified > 0L && lastModified <= ifModifiedSince + 999L;
    }
}

