/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.filter.gzip;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.server.commons.BufferedServletInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(GzipServletRequestWrapper.class);
    private BufferedServletInputStream m_buf;
    private int m_compressedLength = -1;
    private int m_uncompressedLength = -1;

    public GzipServletRequestWrapper(HttpServletRequest req) {
        super(req);
    }

    protected BufferedServletInputStream ensureBufferedStream() throws IOException {
        if (this.m_buf == null) {
            byte[] gzipped = IOUtility.readBytes((InputStream)super.getInputStream(), (int)super.getContentLength());
            this.m_compressedLength = gzipped.length;
            this.m_buf = new BufferedServletInputStream(IOUtility.uncompressGzip((byte[])gzipped));
            this.m_uncompressedLength = this.m_buf.getLength();
        }
        return this.m_buf;
    }

    public int getUncompressedLength() {
        return this.m_uncompressedLength;
    }

    public int getCompressedLength() {
        return this.m_compressedLength;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.ensureBufferedStream();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)((Object)this.ensureBufferedStream())));
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public int getContentLength() {
        try {
            return this.ensureBufferedStream().getLength();
        }
        catch (IOException ex) {
            LOG.warn("Error while reading GZIP content", (Throwable)ex);
            return -1;
        }
    }

    public String getHeader(String name) {
        if ("Content-Encoding".equals(name)) {
            return null;
        }
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if ("Content-Encoding".equals(name)) {
            return Collections.emptyEnumeration();
        }
        return super.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        Enumeration names = super.getHeaderNames();
        if (names != null) {
            ArrayList list = Collections.list(names);
            list.remove("Content-Encoding");
            return Collections.enumeration(list);
        }
        return names;
    }
}

