/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.logging;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.config.AbstractConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.HexUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ApplicationScoped
public class HttpSessionIdLogHelper {
    public static final String SESSION_ATTRIBUTE = HttpSessionIdLogHelper.class.getName();

    public String getSessionIdForLogging(HttpSession session) {
        if (session == null) {
            return null;
        }
        String precomputedResult = (String)session.getAttribute(SESSION_ATTRIBUTE);
        if (precomputedResult != null) {
            return StringUtility.nullIfEmpty((Object)precomputedResult);
        }
        String result = this.computeSessionIdForLogging(session.getId(), (HttpSessionIdLogMode)((Object)CONFIG.getPropertyValue(HttpSessionIdLogModeProperty.class)));
        session.setAttribute(SESSION_ATTRIBUTE, (Object)StringUtility.emptyIfNull((Object)result));
        return result;
    }

    protected String computeSessionIdForLogging(String sessionId, HttpSessionIdLogMode mode) {
        if (sessionId == null || mode == HttpSessionIdLogMode.FULL) {
            return sessionId;
        }
        if (mode == HttpSessionIdLogMode.SHORT) {
            try {
                return StringUtility.join((String)"~", (Object[])new Object[]{StringUtility.box((String)"#", (String)this.getShortHash(sessionId), (String)""), this.getSuffix(sessionId)});
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected String getSuffix(String sessionId) {
        if (sessionId.length() < 30) {
            return null;
        }
        int dotIndex = sessionId.indexOf(".", 15);
        if (dotIndex >= 15) {
            return sessionId.substring(dotIndex - 4, dotIndex);
        }
        return sessionId.substring(sessionId.length() - 4);
    }

    protected String getShortHash(String sessionId) throws NoSuchAlgorithmException {
        return StringUtility.substring((String)this.getHash(sessionId), (int)0, (int)10);
    }

    protected String getHash(String sessionId) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        messageDigest = MessageDigest.getInstance("MD5");
        return HexUtility.encode((byte[])messageDigest.digest(sessionId.getBytes(StandardCharsets.UTF_8)));
    }

    public static enum HttpSessionIdLogMode {
        OFF("off"),
        SHORT("short"),
        FULL("full");

        private final String m_id;

        private HttpSessionIdLogMode(String id) {
            this.m_id = id;
        }

        public String getId() {
            return this.m_id;
        }
    }

    public static class HttpSessionIdLogModeProperty
    extends AbstractConfigProperty<HttpSessionIdLogMode, String> {
        public String getKey() {
            return "scout.diagnostics.httpSessionIdLogMode";
        }

        public HttpSessionIdLogMode getDefaultValue() {
            if (Platform.get().inDevelopmentMode()) {
                return HttpSessionIdLogMode.FULL;
            }
            return HttpSessionIdLogMode.SHORT;
        }

        protected HttpSessionIdLogMode parse(String value) {
            String trimmedValue = StringUtility.trim((String)value);
            return Stream.of(HttpSessionIdLogMode.values()).filter(m -> m.getId().equalsIgnoreCase(trimmedValue)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid value: '" + value + "'"));
        }

        public String description() {
            return "Specifies in which form the HTTP session ID is provided as diagnostic context value.\nPossible modes:\n'" + HttpSessionIdLogMode.OFF.getId() + "': No HTTP session ID is provided.\n" + "'" + HttpSessionIdLogMode.SHORT.getId() + "': Only a short and obfuscated version of the HTTP session is provided. The actual ID cannot be recovered from this.\n" + "'" + HttpSessionIdLogMode.FULL.getId() + "': The full HTTP session ID is provided, as reported by the application server. " + "CAUTION: Only use this mode if you can guarantee that no malicious third party has access to the log files. Otherwise they might be able to hijack active sessions.\n" + "In development mode, the default value is '" + HttpSessionIdLogMode.FULL.getId() + "'. " + "Otherwise, the default value is '" + HttpSessionIdLogMode.SHORT.getId() + "'.";
        }
    }
}

