/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.server.runner.statement;

import java.security.AccessController;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.context.ServerRunContexts;
import org.eclipse.scout.rt.server.session.ServerSessionProvider;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.shared.ui.UserAgents;
import org.eclipse.scout.rt.testing.platform.runner.RunWithSubject;
import org.eclipse.scout.rt.testing.platform.runner.SafeStatementInvoker;
import org.eclipse.scout.rt.testing.server.runner.RunWithServerSession;
import org.junit.runners.model.Statement;

public class ServerRunContextStatement
extends Statement {
    private final Statement m_next;
    private final RunWithServerSession m_serverSessionAnnotation;

    public ServerRunContextStatement(Statement next, RunWithServerSession serverSessionAnnotation) {
        this.m_next = (Statement)Assertions.assertNotNull((Object)next, (String)"next statement must not be null", (Object[])new Object[0]);
        this.m_serverSessionAnnotation = serverSessionAnnotation;
    }

    public void evaluate() throws Throwable {
        if (this.m_serverSessionAnnotation == null) {
            this.m_next.evaluate();
        } else {
            this.evaluateWithServerRunContext();
        }
    }

    private void evaluateWithServerRunContext() throws Throwable {
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        if (currentSubject == null) {
            Assertions.fail((String)"Subject must not be null. Use the annotation '{}' to execute your test under a particular user. ", (Object[])new Object[]{RunWithSubject.class.getSimpleName()});
        }
        UserAgent userAgent = UserAgents.createDefault();
        Class sessionClass = this.m_serverSessionAnnotation.value();
        IBean sessionBean = BEANS.getBeanManager().uniqueBean(sessionClass);
        if (sessionBean != null) {
            sessionClass = sessionBean.getBeanClazz();
        }
        IBean serverSessionBean = BEANS.getBeanManager().registerBean(new BeanMetaData(sessionClass).withOrder(-9.223372036854776E18));
        try {
            IServerSession serverSession = ((ServerSessionProvider)BEANS.get(this.m_serverSessionAnnotation.provider())).provide(ServerRunContexts.copyCurrent().withSubject(currentSubject).withUserAgent(userAgent));
            SafeStatementInvoker invoker = new SafeStatementInvoker(this.m_next);
            ServerRunContexts.copyCurrent().withSession(serverSession).withSubject(currentSubject).withUserAgent(userAgent).run((IRunnable)invoker);
            invoker.throwOnError();
        }
        finally {
            BEANS.getBeanManager().unregisterBean(serverSessionBean);
        }
    }
}

