/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.util.FileUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.HttpServletControl;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheControl;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheKey;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheObject;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String m_warPath;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_warPath = this.parseWarPath(config.getInitParameter("war-path"));
    }

    protected String parseWarPath(String value) throws ServletException {
        if (value != null && value.endsWith("/")) {
            return value.substring(0, value.length() - 1);
        }
        if (!StringUtility.hasText((CharSequence)value)) {
            throw new ServletException("Missing init parameters. Set 'war-path' parameter.");
        }
        return value;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ((HttpServletControl)BEANS.get(HttpServletControl.class)).doDefaults((HttpServlet)this, req, res);
        String uri = req.getRequestURI();
        int lastSlashPos = uri.lastIndexOf(47);
        String lastSegment = null;
        if (lastSlashPos >= 0 && uri.length() > lastSlashPos) {
            lastSegment = uri.substring(lastSlashPos + 1);
        }
        if (lastSegment != null && lastSegment.contains(".") || uri.endsWith("/")) {
            if (!this.writeStaticResource(req, res)) {
                res.setStatus(404);
            }
        } else {
            res.sendRedirect(String.valueOf(req.getRequestURI()) + "/");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ((HttpServletControl)BEANS.get(HttpServletControl.class)).doDefaults((HttpServlet)this, req, res);
        if (!this.writeStaticResource(req, res)) {
            res.setStatus(404);
        }
    }

    private boolean writeStaticResource(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        if (StringUtility.isNullOrEmpty((CharSequence)pathInfo) || pathInfo.endsWith("/")) {
            pathInfo = "/index.html";
        }
        URL url = null;
        String contentType = null;
        if (this.m_warPath != null) {
            ServletContext servletContext = this.getServletContext();
            String resourcePath = String.valueOf(this.m_warPath) + pathInfo;
            url = servletContext.getResource(resourcePath);
            contentType = FileUtility.getMimeType((String)resourcePath);
        }
        if (url == null) {
            return false;
        }
        URLConnection connection = url.openConnection();
        long lastModified = connection.getLastModified();
        int contentLength = connection.getContentLength();
        BinaryResource res = BinaryResources.create().withFilename(pathInfo).withContentType(contentType).withLastModified(lastModified).build();
        HttpCacheObject obj = new HttpCacheObject(new HttpCacheKey(pathInfo), res);
        if (((HttpCacheControl)BEANS.get(HttpCacheControl.class)).checkAndSetCacheHeaders(req, resp, obj)) {
            return true;
        }
        Throwable throwable = null;
        Object var13_15 = null;
        try (InputStream is = connection.getInputStream();){
            ServletOutputStream os = resp.getOutputStream();
            byte[] buffer = new byte[8192];
            int bytesRead = is.read(buffer);
            int writtenContentLength = 0;
            while (bytesRead != -1) {
                os.write(buffer, 0, bytesRead);
                writtenContentLength += bytesRead;
                bytesRead = is.read(buffer);
            }
            if (contentLength == -1 || contentLength != writtenContentLength) {
                resp.setContentLength(writtenContentLength);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }
}

