/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.config.AbstractPositiveLongConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty;
import org.eclipse.scout.rt.server.services.common.file.RemoteFileService;

public final class ServerConfigProperties {
    private ServerConfigProperties() {
    }

    public static class ClusterSyncUserProperty
    extends AbstractStringConfigProperty {
        public static final String CLUSTER_SYNC_USER_NAME = "system";

        public String getDefaultValue() {
            return CLUSTER_SYNC_USER_NAME;
        }

        public String getKey() {
            return "scout.clustersync.user";
        }

        public String description() {
            return String.format("Technical subject under which received cluster sync notifications are executed. The default value is '%s'.", CLUSTER_SYNC_USER_NAME);
        }
    }

    public static class RemoteFilesRootDirProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.remotefileRootPath";
        }

        public String description() {
            return String.format("Absolute path to the root directory of the '%s'. The default value is null.", RemoteFileService.class.getSimpleName());
        }
    }

    public static class ServerSessionCacheExpirationProperty
    extends AbstractPositiveLongConfigProperty {
        public Long getDefaultValue() {
            return TimeUnit.DAYS.toMillis(1L);
        }

        public String getKey() {
            return "scout.serverSessionTtl";
        }

        public String description() {
            return "Server sessions that have not been accessed for the specified number of milliseconds are removed from the cache. The default value is one day.";
        }
    }
}

