/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.IThrowableWithContextInfo;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.serialization.SerializationUtility;
import org.eclipse.scout.rt.platform.service.IService;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.admin.inspector.CallInspector;
import org.eclipse.scout.rt.server.admin.inspector.ProcessInspector;
import org.eclipse.scout.rt.server.admin.inspector.SessionInspector;
import org.eclipse.scout.rt.server.session.ServerSessionProvider;
import org.eclipse.scout.rt.shared.security.RemoteServiceAccessPermission;
import org.eclipse.scout.rt.shared.servicetunnel.RemoteServiceAccessDenied;
import org.eclipse.scout.rt.shared.servicetunnel.RemoteServiceWithoutAuthorization;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ServiceOperationInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceOperationInvoker.class);

    public ServiceTunnelResponse invoke(RunContext runContext, ServiceTunnelRequest serviceReq) {
        ServiceTunnelResponse response;
        long t0 = System.nanoTime();
        try {
            response = (ServiceTunnelResponse)runContext.call(() -> this.invokeInternal(serviceReq), DefaultExceptionTranslator.class);
        }
        catch (Exception e) {
            if (e instanceof PlatformException) {
                ((IThrowableWithContextInfo)e).withContextInfo("service.name", (Object)serviceReq.getServiceInterfaceClassName(), new Object[0]).withContextInfo("service.operation", (Object)serviceReq.getOperation(), new Object[0]);
            }
            this.handleException(e);
            response = new ServiceTunnelResponse(this.interceptException(e));
        }
        response.setProcessingDuration(Long.valueOf(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
        LOG.debug("TIME {}.{} {}ms", new Object[]{serviceReq.getServiceInterfaceClassName(), serviceReq.getOperation(), response.getProcessingDuration()});
        return response;
    }

    protected ServiceTunnelResponse invokeInternal(ServiceTunnelRequest serviceReq) throws ClassNotFoundException {
        IServerSession serverSession = ServerSessionProvider.currentSession();
        if (LOG.isDebugEnabled()) {
            String userId = serverSession != null ? serverSession.getUserId() : "";
            LOG.debug("started {}.{} by {} at {}", new Object[]{serviceReq.getServiceInterfaceClassName(), serviceReq.getOperation(), userId, new Date()});
        }
        CallInspector callInspector = this.getCallInspector(serviceReq, serverSession);
        ServiceTunnelResponse serviceRes = null;
        try {
            ServiceUtility serviceUtility = (ServiceUtility)BEANS.get(ServiceUtility.class);
            Class<?> serviceInterfaceClass = SerializationUtility.getClassLoader().loadClass(serviceReq.getServiceInterfaceClassName());
            Method serviceOp = serviceUtility.getServiceOperation(serviceInterfaceClass, serviceReq.getOperation(), serviceReq.getParameterTypes());
            Object[] args = serviceReq.getArgs();
            Object service = this.getValidatedServiceAccess(serviceInterfaceClass, serviceOp, args);
            Object data = serviceUtility.invoke(service, serviceOp, args);
            ServiceTunnelResponse serviceTunnelResponse = serviceRes = new ServiceTunnelResponse(data);
            this.updateInspector(callInspector, serviceRes);
            return serviceTunnelResponse;
        }
        catch (Throwable throwable) {
            this.updateInspector(callInspector, serviceRes);
            throw throwable;
        }
    }

    private void updateInspector(CallInspector callInspector, ServiceTunnelResponse serviceRes) {
        if (callInspector != null) {
            try {
                callInspector.update();
            }
            catch (RuntimeException e) {
                LOG.warn("Could not update call inspector", (Throwable)e);
            }
            try {
                callInspector.close(serviceRes);
            }
            catch (RuntimeException e) {
                LOG.warn("Could not close service invocation on call inspector", (Throwable)e);
            }
            try {
                callInspector.getSessionInspector().update();
            }
            catch (RuntimeException e) {
                LOG.warn("Could not update session inspector", (Throwable)e);
            }
        }
    }

    protected Object getValidatedServiceAccess(Class<?> serviceInterfaceClass, Method serviceOp, Object[] args) {
        Object service = BEANS.opt(serviceInterfaceClass);
        this.checkServiceAvailable(serviceInterfaceClass, service);
        this.checkRemoteServiceAccessByInterface(serviceInterfaceClass, serviceOp, args);
        this.checkRemoteServiceAccessByAnnotations(serviceInterfaceClass, service.getClass(), serviceOp, args);
        if (this.mustAuthorize(serviceInterfaceClass, service.getClass(), serviceOp, args)) {
            this.checkRemoteServiceAccessByPermission(serviceInterfaceClass, service.getClass(), serviceOp, args);
        }
        return service;
    }

    protected void checkServiceAvailable(Class<?> serviceInterfaceClass, Object service) {
        if (service == null) {
            throw new SecurityException("service registry does not contain a service of type " + serviceInterfaceClass.getName());
        }
    }

    protected void checkRemoteServiceAccessByInterface(Class<?> interfaceClass, Method interfaceMethod, Object[] args) {
        Method verifyMethod;
        if (!interfaceClass.isInterface()) {
            throw new SecurityException("access denied (code 1a).");
        }
        try {
            verifyMethod = interfaceClass.getMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
        }
        catch (NoSuchMethodException | RuntimeException t) {
            LOG.debug("Could not lookup service method", (Throwable)t);
            throw new SecurityException("access denied (code 1c).");
        }
        if (verifyMethod.getDeclaringClass() == IService.class) {
            throw new SecurityException("access denied (code 1d).");
        }
    }

    protected void checkRemoteServiceAccessByAnnotations(Class<?> interfaceClass, Class<?> implClass, Method interfaceMethod, Object[] args) {
        Class<?> c = implClass;
        while (c != null) {
            Method m = null;
            try {
                m = c.getMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
            }
            catch (NoSuchMethodException | RuntimeException t) {
                LOG.debug("Could not lookup service method", (Throwable)t);
            }
            if (m != null && m.isAnnotationPresent(RemoteServiceAccessDenied.class)) {
                throw new SecurityException("access denied (code 2b).");
            }
            if (c.isAnnotationPresent(RemoteServiceAccessDenied.class)) {
                throw new SecurityException("access denied (code 2c).");
            }
            if (c == interfaceClass) break;
            if ((c = c.getSuperclass()) != Object.class) continue;
            c = interfaceClass;
        }
    }

    protected void checkRemoteServiceAccessByPermission(Class<?> interfaceClass, Class<?> implClass, Method interfaceMethod, Object[] args) {
        if (ACCESS.check((Permission)new RemoteServiceAccessPermission(interfaceClass.getName(), interfaceMethod.getName()))) {
            return;
        }
        throw new SecurityException("access denied (code 3a).");
    }

    protected boolean mustAuthorize(Class<?> interfaceClass, Class<?> implClass, Method interfaceMethod, Object[] args) {
        Class<?> c = implClass;
        while (c != null) {
            Method m = null;
            try {
                m = c.getMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
            }
            catch (NoSuchMethodException | RuntimeException t) {
                LOG.debug("Could not lookup service method", (Throwable)t);
            }
            if (m != null && m.isAnnotationPresent(RemoteServiceWithoutAuthorization.class)) {
                return false;
            }
            if (c.isAnnotationPresent(RemoteServiceWithoutAuthorization.class)) {
                return false;
            }
            if (c == interfaceClass) break;
            if ((c = c.getSuperclass()) != Object.class) continue;
            c = interfaceClass;
        }
        return true;
    }

    private CallInspector getCallInspector(ServiceTunnelRequest serviceReq, IServerSession serverSession) {
        SessionInspector sessionInspector;
        if (serverSession != null && (sessionInspector = ((ProcessInspector)BEANS.get(ProcessInspector.class)).getSessionInspector(serverSession, true)) != null) {
            return sessionInspector.requestCallInspector(serviceReq);
        }
        return null;
    }

    protected void handleException(Throwable t) {
        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(t);
    }

    protected Throwable interceptException(Throwable t) {
        ProcessingException p;
        if (t instanceof VetoException) {
            VetoException ve = (VetoException)t;
            p = new VetoException(ve.getStatus().getBody(), new Object[0]).withTitle(ve.getStatus().getTitle(), new Object[0]).withHtmlMessage(ve.getHtmlMessage()).withCode(ve.getStatus().getCode()).withSeverity(ve.getStatus().getSeverity());
        } else {
            p = new ProcessingException(TEXTS.get((String)"RequestProblem"), new Object[0]);
        }
        p.setStackTrace(new StackTraceElement[0]);
        return p;
    }
}

