/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import java.util.function.LongPredicate;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.transaction.TransactionCancelledError;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.concurrent.AbstractInterruptionError;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruption;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServiceOperationInvoker;
import org.eclipse.scout.rt.server.admin.html.AdminSession;
import org.eclipse.scout.rt.server.commons.idempotent.DuplicateRequestException;
import org.eclipse.scout.rt.server.commons.idempotent.SequenceNumberDuplicateDetector;
import org.eclipse.scout.rt.server.commons.servlet.AbstractHttpServlet;
import org.eclipse.scout.rt.server.commons.servlet.HttpServletControl;
import org.eclipse.scout.rt.server.commons.servlet.IHttpServletRoundtrip;
import org.eclipse.scout.rt.server.commons.servlet.ServletExceptionTranslator;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheControl;
import org.eclipse.scout.rt.server.context.HttpServerRunContextProducer;
import org.eclipse.scout.rt.server.context.RunMonitorCancelRegistry;
import org.eclipse.scout.rt.server.context.ServerRunContext;
import org.eclipse.scout.rt.server.context.ServerRunContexts;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.rt.shared.ui.UserAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTunnelServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ServiceTunnelServlet.class);
    protected static final String ADMIN_SESSION_KEY = "AdminSessionKey";
    protected static final String DUPLICATE_REQUEST_DETECTOR_SESSION_KEY = "DuplicateRequestDetector";
    protected transient IServiceTunnelContentHandler m_contentHandler;
    protected transient LazyValue<HttpServerRunContextProducer> m_serverRunContextProducer = new LazyValue(HttpServerRunContextProducer.class);
    protected transient LazyValue<HttpServletControl> m_httpServletControl = new LazyValue(HttpServletControl.class);
    protected transient LazyValue<HttpCacheControl> m_httpCacheControl = new LazyValue(HttpCacheControl.class);
    protected transient LazyValue<ServiceOperationInvoker> m_svcInvoker = new LazyValue(ServiceOperationInvoker.class);
    protected transient LazyValue<RunMonitorCancelRegistry> m_runMonCancelRegistry = new LazyValue(RunMonitorCancelRegistry.class);

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        if (Subject.getSubject(AccessController.getContext()) == null) {
            servletResponse.sendError(403);
            return;
        }
        this.lazyInit(servletRequest, servletResponse);
        ((HttpServerRunContextProducer)BEANS.get(HttpServerRunContextProducer.class)).withSessionSupport(false).produce(servletRequest, servletResponse).run(() -> this.invokeAdminService(ServerRunContexts.copyCurrent()), ServletExceptionTranslator.class);
    }

    protected void invokeAdminService(ServerRunContext serverRunContext) throws Exception {
        serverRunContext.run(() -> {
            HttpServletRequest servletRequest = (HttpServletRequest)IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_REQUEST.get();
            HttpServletResponse servletResponse = (HttpServletResponse)IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_RESPONSE.get();
            ((HttpServletControl)this.m_httpServletControl.get()).doDefaults((HttpServlet)this, servletRequest, servletResponse);
            this.getAdminSession(servletRequest).serviceRequest(servletRequest, servletResponse);
        }, DefaultExceptionTranslator.class);
    }

    protected AdminSession getAdminSession(HttpServletRequest servletRequest) {
        HttpSession httpSession = servletRequest.getSession();
        AdminSession adminSession = (AdminSession)httpSession.getAttribute(ADMIN_SESSION_KEY);
        if (adminSession == null) {
            adminSession = new AdminSession();
            httpSession.setAttribute(ADMIN_SESSION_KEY, (Object)adminSession);
        }
        return adminSession;
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (Subject.getSubject(AccessController.getContext()) == null) {
            servletResponse.sendError(403);
            return;
        }
        this.lazyInit(servletRequest, servletResponse);
        try {
            ((HttpServerRunContextProducer)this.m_serverRunContextProducer.get()).getInnerRunContextProducer().produce(servletRequest, servletResponse).run(() -> {
                ServiceTunnelRequest serviceRequest = this.deserializeServiceRequest();
                ServiceTunnelResponse serviceResponse = this.doPost(serviceRequest);
                ThreadInterruption.IRestorer interruption = ThreadInterruption.clear();
                try {
                    this.serializeServiceResponse(serviceResponse);
                }
                finally {
                    interruption.restore();
                }
            }, DefaultExceptionTranslator.class);
        }
        catch (DuplicateRequestException e) {
            boolean interrupted = Thread.interrupted();
            if (interrupted) {
                LOG.debug("Duplicate Request{}", (Object)this.interruptInfo(interrupted), (Object)e);
            } else {
                LOG.warn("Duplicate Request{}", (Object)this.interruptInfo(interrupted), (Object)e);
            }
            servletResponse.sendError(409, "Request is a duplicate");
        }
        catch (Throwable e) {
            boolean interrupted = Thread.interrupted();
            if (this.isConnectionError(e)) {
                LOG.debug("Connection Error{}", (Object)this.interruptInfo(interrupted), (Object)e);
                servletResponse.sendError(202, "Connection probably dropped by client");
            }
            if (this.isInterruption(e)) {
                if (this.isCancellation(e)) {
                    LOG.debug("Cancelled by client{}", (Object)this.interruptInfo(interrupted), (Object)e);
                    servletResponse.sendError(202, "Request processing was cancelled");
                } else {
                    LOG.info("Interruption{}", (Object)this.interruptInfo(interrupted), (Object)e);
                    servletResponse.sendError(202, "Request processing was interrupted");
                }
            }
            LOG.error("Client={}@{}/{}", new Object[]{servletRequest.getRemoteUser(), servletRequest.getRemoteAddr(), servletRequest.getRemoteHost(), e});
            servletResponse.sendError(500);
        }
    }

    protected ServiceTunnelResponse doPost(ServiceTunnelRequest serviceRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("requestSequence {} {}.{}", new Object[]{serviceRequest.getRequestSequence(), serviceRequest.getServiceInterfaceClassName(), serviceRequest.getOperation()});
        }
        ServerRunContext serverRunContext = this.createServiceTunnelRunContext(serviceRequest);
        RunMonitorCancelRegistry.IRegistrationHandle registrationHandle = this.registerForCancellation(serverRunContext, serviceRequest);
        try {
            ServiceTunnelResponse serviceResponse = this.invokeService(serverRunContext, serviceRequest);
            serviceResponse.setNotifications(serverRunContext.getClientNotificationCollector().consume());
            ServiceTunnelResponse serviceTunnelResponse = serviceResponse;
            return serviceTunnelResponse;
        }
        finally {
            registrationHandle.unregister();
        }
    }

    protected String interruptInfo(boolean interrupted) {
        return interrupted ? ", thread was interrupted" : ", thread was not interrupted";
    }

    protected ServerRunContext createServiceTunnelRunContext(ServiceTunnelRequest serviceRequest) {
        ServerRunContext serverRunContext = ServerRunContexts.copyCurrent().withLocale(serviceRequest.getLocale()).withUserAgent(UserAgents.createByIdentifier((String)serviceRequest.getUserAgent())).withClientNodeId(serviceRequest.getClientNodeId());
        if (serviceRequest.getSessionId() != null) {
            HttpServletRequest req = (HttpServletRequest)IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_REQUEST.get();
            IServerSession session = ((HttpServerRunContextProducer)this.m_serverRunContextProducer.get()).getOrCreateScoutSession(req, serverRunContext, serviceRequest.getSessionId());
            serverRunContext.withSession(session);
            LongPredicate duplicateRequestDetector = (LongPredicate)session.computeDataIfAbsent(DUPLICATE_REQUEST_DETECTOR_SESSION_KEY, this::createRequestSequenceValidator);
            if (!duplicateRequestDetector.test(serviceRequest.getRequestSequence())) {
                StringBuilder buf = new StringBuilder().append("clientNodeId: ").append(serviceRequest.getClientNodeId()).append(", ").append("sessionId: ").append(serviceRequest.getSessionId()).append(", ").append("operation: ").append(serviceRequest.getServiceInterfaceClassName()).append(".").append(serviceRequest.getOperation());
                throw DuplicateRequestException.create((String)buf.toString(), (long)serviceRequest.getRequestSequence());
            }
        }
        return serverRunContext;
    }

    protected LongPredicate createRequestSequenceValidator() {
        return new SequenceNumberDuplicateDetector(100, 1L, TimeUnit.MINUTES, true);
    }

    protected RunMonitorCancelRegistry.IRegistrationHandle registerForCancellation(ServerRunContext runContext, ServiceTunnelRequest req) {
        String sessionId = runContext.getSession() != null ? runContext.getSession().getId() : null;
        return ((RunMonitorCancelRegistry)this.m_runMonCancelRegistry.get()).register(runContext.getRunMonitor(), sessionId, req.getRequestSequence());
    }

    protected ServiceTunnelResponse invokeService(ServerRunContext serverRunContext, ServiceTunnelRequest serviceTunnelRequest) {
        return ((ServiceOperationInvoker)this.m_svcInvoker.get()).invoke(serverRunContext, serviceTunnelRequest);
    }

    protected ServiceTunnelRequest deserializeServiceRequest() throws IOException, ClassNotFoundException {
        return this.m_contentHandler.readRequest((InputStream)((HttpServletRequest)IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_REQUEST.get()).getInputStream());
    }

    protected void serializeServiceResponse(ServiceTunnelResponse serviceResponse) throws IOException {
        HttpServletRequest req = (HttpServletRequest)IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_REQUEST.get();
        HttpServletResponse resp = (HttpServletResponse)IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_RESPONSE.get();
        ((HttpServletControl)this.m_httpServletControl.get()).doDefaults((HttpServlet)this, req, resp);
        ((HttpCacheControl)this.m_httpCacheControl.get()).checkAndSetCacheHeaders(req, resp, null);
        resp.setContentType(this.m_contentHandler.getContentType());
        this.m_contentHandler.writeResponse((OutputStream)resp.getOutputStream(), serviceResponse);
    }

    protected void lazyInit(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        if (this.m_contentHandler != null) {
            return;
        }
        this.m_contentHandler = this.createContentHandler();
    }

    protected IServiceTunnelContentHandler createContentHandler() {
        IServiceTunnelContentHandler e = (IServiceTunnelContentHandler)BEANS.get(IServiceTunnelContentHandler.class);
        e.initialize();
        return e;
    }

    protected boolean isConnectionError(Throwable e) {
        Throwable cause = e;
        while (cause != null) {
            if (cause instanceof SocketException) {
                return true;
            }
            if ("EofException".equalsIgnoreCase(cause.getClass().getSimpleName())) {
                return true;
            }
            if (cause instanceof InterruptedIOException) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    protected boolean isInterruption(Throwable e) {
        Throwable cause = e;
        while (cause != null) {
            if (cause instanceof AbstractInterruptionError) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    protected boolean isCancellation(Throwable e) {
        Throwable cause = e;
        while (cause != null) {
            if (cause instanceof FutureCancelledError) {
                return true;
            }
            if (cause instanceof TransactionCancelledError) {
                return true;
            }
            if (cause instanceof ThreadInterruptedError) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }
}

