/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.diagnostic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.server.admin.diagnostic.IDiagnostic;

public final class DiagnosticFactory {
    public static final String STATUS_TITLE = "TITLE";
    public static final String STATUS_INFO = "INFO";
    public static final String STATUS_FAILED = "FAILED";
    public static final String STATUS_OK = "OK";
    public static final String STATUS_ACTIVE = "ACTIVE";
    public static final String STATUS_INACTIVE = "INACTIVE";
    private static final List<IDiagnostic> DIAGNOSTIC_STATUS_PROVIDERS = new ArrayList<IDiagnostic>();
    private static final Map<String, IDiagnostic> DIAGNOSTIC_STATUS_PROVIDER_ACTION_MAP = new HashMap<String, IDiagnostic>();

    private DiagnosticFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDiagnosticStatusProvider(IDiagnostic statusProvider) {
        List<IDiagnostic> list = DIAGNOSTIC_STATUS_PROVIDERS;
        synchronized (list) {
            DIAGNOSTIC_STATUS_PROVIDERS.add(statusProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDiagnosticStatusProvider(IDiagnostic statusProvider) {
        Object object = DIAGNOSTIC_STATUS_PROVIDERS;
        synchronized (object) {
            DIAGNOSTIC_STATUS_PROVIDERS.remove(statusProvider);
        }
        object = DIAGNOSTIC_STATUS_PROVIDER_ACTION_MAP;
        synchronized (object) {
            DIAGNOSTIC_STATUS_PROVIDER_ACTION_MAP.entrySet().removeIf(entry -> entry.getValue() == statusProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDiagnostic[] getDiagnosticProviders() {
        List<IDiagnostic> list = DIAGNOSTIC_STATUS_PROVIDERS;
        synchronized (list) {
            IDiagnostic[] copy = DIAGNOSTIC_STATUS_PROVIDERS.toArray(new IDiagnostic[0]);
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addActionToDiagnosticStatusProvider(String action, IDiagnostic statusProvider) {
        Map<String, IDiagnostic> map = DIAGNOSTIC_STATUS_PROVIDER_ACTION_MAP;
        synchronized (map) {
            DIAGNOSTIC_STATUS_PROVIDER_ACTION_MAP.put(action, statusProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDiagnostic getDiagnosticProvider(String action) {
        Map<String, IDiagnostic> map = DIAGNOSTIC_STATUS_PROVIDER_ACTION_MAP;
        synchronized (map) {
            return DIAGNOSTIC_STATUS_PROVIDER_ACTION_MAP.get(action);
        }
    }

    public static void addDiagnosticItemToList(List<List<String>> list, String attribute, String value, String status) {
        ArrayList<String> newItem = new ArrayList<String>();
        newItem.add(attribute);
        newItem.add(value);
        newItem.add(status);
        list.add(newItem);
    }
}

