/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.diagnostic;

import java.io.IOException;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.server.ServiceTunnelServlet;
import org.eclipse.scout.rt.server.admin.diagnostic.DiagnosticSession;
import org.eclipse.scout.rt.server.commons.servlet.IHttpServletRoundtrip;
import org.eclipse.scout.rt.server.commons.servlet.ServletExceptionTranslator;
import org.eclipse.scout.rt.server.context.HttpServerRunContextProducer;
import org.eclipse.scout.rt.server.context.ServerRunContext;
import org.eclipse.scout.rt.server.context.ServerRunContexts;

public class DiagnosticServlet
extends ServiceTunnelServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    @Override
    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (Subject.getSubject(AccessController.getContext()) == null) {
            servletResponse.sendError(403);
            return;
        }
        this.lazyInit(servletRequest, servletResponse);
        ((HttpServerRunContextProducer)BEANS.get(HttpServerRunContextProducer.class)).withSessionSupport(false).produce(servletRequest, servletResponse).run(() -> this.invokeDiagnosticService(ServerRunContexts.copyCurrent()), ServletExceptionTranslator.class);
    }

    protected void invokeDiagnosticService(ServerRunContext serverRunContext) throws Exception {
        serverRunContext.run(() -> {
            HttpServletRequest servletRequest = (HttpServletRequest)IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_REQUEST.get();
            HttpServletResponse servletResponse = (HttpServletResponse)IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_RESPONSE.get();
            new DiagnosticSession().serviceRequest(servletRequest, servletResponse);
        }, DefaultExceptionTranslator.class);
    }
}

