/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.diagnostic;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Permission;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.server.admin.diagnostic.DiagnosticFactory;
import org.eclipse.scout.rt.server.admin.diagnostic.IDiagnostic;
import org.eclipse.scout.rt.shared.OfficialVersion;
import org.eclipse.scout.rt.shared.security.ReadDiagnosticServletPermission;
import org.eclipse.scout.rt.shared.security.UpdateDiagnosticServletPermission;

public class DiagnosticSession {
    public void serviceRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String format;
        if (!req.getParameterMap().isEmpty()) {
            Iterator iterator = req.getParameterMap().entrySet().iterator();
            while (iterator.hasNext()) {
                boolean hasUpdateDiagnosticsServletPermission;
                Map.Entry stringEntry;
                Map.Entry next = stringEntry = iterator.next();
                String action = (String)next.getKey();
                Object value = next.getValue();
                IDiagnostic diagnosticProvider = DiagnosticFactory.getDiagnosticProvider(action);
                if (diagnosticProvider == null || !(value instanceof Object[]) || !(hasUpdateDiagnosticsServletPermission = ACCESS.check((Permission)new UpdateDiagnosticServletPermission()))) continue;
                diagnosticProvider.call(action, (Object[])value);
            }
        }
        if (ObjectUtility.equals((Object)"xml", (Object)(format = req.getParameter("format")))) {
            this.doXmlResponse(res);
        } else {
            this.doHtmlResponse(req, res);
        }
    }

    private void doXmlResponse(HttpServletResponse resp) throws IOException {
        List<List<String>> result = this.getDiagnosticItems();
        String diagnosticXML = this.getDiagnosticItemsXML(result);
        resp.setContentType("text/xml");
        ServletOutputStream out = resp.getOutputStream();
        out.println("<?xml version='1.0' encoding='UTF-8' ?>");
        out.println("<diagnosticsStatus>");
        out.println(diagnosticXML);
        out.println("</diagnosticsStatus>");
    }

    private void doHtmlResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IDiagnostic[] diagnosticServices;
        boolean hasReadDiagnosticsServletPermission = ACCESS.check((Permission)new ReadDiagnosticServletPermission());
        boolean hasUpdateDiagnosticsServletPermission = ACCESS.check((Permission)new UpdateDiagnosticServletPermission());
        String errorMsg = "";
        String doGc = req.getParameter("gc");
        if (StringUtility.hasText((CharSequence)doGc)) {
            System.gc();
            errorMsg = "<font color='blue'> System.gc() triggered.</font>";
        }
        if (!hasUpdateDiagnosticsServletPermission && !req.getParameterMap().isEmpty()) {
            errorMsg = "<font color='red'>" + new UpdateDiagnosticServletPermission().getName() + " required to update values.</font>";
        }
        List<List<String>> result = this.getDiagnosticItems();
        IDiagnostic[] iDiagnosticArray = diagnosticServices = DiagnosticFactory.getDiagnosticProviders();
        int n = diagnosticServices.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagnostic diagnosticService = iDiagnosticArray[n2];
            if (CollectionUtility.hasElements((Object[])diagnosticService.getPossibleActions())) {
                diagnosticService.addSubmitButtonsHTML(result);
            }
            ++n2;
        }
        DiagnosticFactory.addDiagnosticItemToList(result, "System.gc()", "", "<input type='checkbox' name='gc' value='yes'/>");
        String diagnosticHTML = this.getDiagnosticItemsHTML(result);
        String title = (String)CONFIG.getPropertyValue(PlatformConfigProperties.ApplicationNameProperty.class);
        String version = (String)CONFIG.getPropertyValue(PlatformConfigProperties.ApplicationVersionProperty.class);
        resp.setContentType("text/html");
        ServletOutputStream out = resp.getOutputStream();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>" + title + "</title>");
        out.println("<style>");
        out.println("body {font-family: sans-serif; font-size: 12; background-color : #F6F6F6;}");
        out.println("a,a:VISITED {color: #6666ff;text-decoration: none;}");
        out.println("table {font-size: 12; empty-cells: show;}");
        out.println("th {text-align: left;vertical-align: top; padding-left: 2; background-color : #cccccc;}");
        out.println("td {text-align: left;vertical-align: top; padding-left: 2;}");
        out.println("p {margin-top: 4; margin-bottom: 4; padding-top: 4; padding-bottom: 4;}");
        out.println("dt {font-weight: bold;}");
        out.println("dd {margin-left: 20px; margin-bottom: 3px;}");
        out.println(".copyright {font-size: 10;}");
        out.println("</style>");
        out.println("<script type=\"text/javascript\">");
        out.println("function toggle_visibility(id) {");
        out.println("   var el = document.getElementById(id);");
        out.println("   el.style.display = (el.style.display != 'none' ? 'none' : 'block');");
        out.println("}");
        out.println("</script>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h3>" + title + " " + version + "</h3>");
        if (hasReadDiagnosticsServletPermission) {
            out.println("<form method='POST' action='" + StringUtility.join((String)"?", (Object[])new Object[]{req.getRequestURL().toString(), req.getQueryString()}) + "'>");
            out.print(diagnosticHTML);
            out.println("<p><input type='submit' value='submit'/></p>");
            out.println("</form>");
        } else {
            out.println("<font color='red'>" + new ReadDiagnosticServletPermission().getName() + " required to access diagnostic data.</font>");
        }
        out.print(errorMsg);
        out.println("<p class=\"copyright\">&copy; " + OfficialVersion.COPYRIGHT + "</p>");
        out.println("</body>");
        out.println("</html>");
    }

    private List<List<String>> getDiagnosticItems() {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        List<String> infos = DiagnosticSession.getSystemInformation();
        DiagnosticFactory.addDiagnosticItemToList(result, "Server", "", "TITLE");
        DiagnosticFactory.addDiagnosticItemToList(result, "Runtime Environment", infos.get(0), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Application Directory", infos.get(1), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "JVM Memory Status", "Max: " + infos.get(2) + ", Reserved: " + infos.get(3) + ", Currently Used: " + infos.get(4), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "JVM Locale", infos.get(11), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Operating System", infos.get(6), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Architecture", infos.get(5), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "#CPUs available to JVM", infos.get(12), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "OS Country / Timezone", String.valueOf(infos.get(9)) + " / " + infos.get(10), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Host Address / Name", String.valueOf(infos.get(13)) + " / " + infos.get(14), "INFO");
        IDiagnostic[] diagnosticServices = DiagnosticFactory.getDiagnosticProviders();
        IDiagnostic[] iDiagnosticArray = diagnosticServices;
        int n = diagnosticServices.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagnostic diagnosticService = iDiagnosticArray[n2];
            diagnosticService.addDiagnosticItemToList(result);
            ++n2;
        }
        ArrayList<String> properties = new ArrayList<String>();
        for (Object property : System.getProperties().keySet()) {
            properties.add("" + property);
        }
        Collections.sort(properties);
        StringBuilder sb = new StringBuilder();
        sb.append("<a href=\"#\" onClick=\"javascript:toggle_visibility('sysprops'); return false;\">(show / hide)</a>");
        sb.append("<div id=\"sysprops\" style=\"width:600px; margin: 0px; padding: 0px; display: none; word-wrap: break-word;\">");
        sb.append("<dl>");
        for (String property : properties) {
            sb.append("<dt>");
            sb.append(property);
            sb.append(":</b></dt><dd>");
            sb.append(System.getProperty(property));
            sb.append("</dd>");
        }
        sb.append("</dl>");
        sb.append("</div>");
        DiagnosticFactory.addDiagnosticItemToList(result, "System properties", sb.toString(), "INFO");
        ArrayList<String> envKeys = new ArrayList<String>();
        envKeys.addAll(System.getenv().keySet());
        Collections.sort(envKeys);
        sb = new StringBuilder();
        sb.append("<a href=\"#\" onClick=\"javascript:toggle_visibility('env'); return false;\">(show / hide)</a>");
        sb.append("<div id=\"env\" style=\"width:600px; margin: 0px; padding: 0px; display: none; word-wrap: break-word;\">");
        sb.append("<dl>");
        for (String envKey : envKeys) {
            sb.append("<dt>");
            sb.append(envKey);
            sb.append(":</b></dt><dd>");
            sb.append(System.getenv(envKey));
            sb.append("</dd>");
        }
        sb.append("</dl>");
        sb.append("</div>");
        DiagnosticFactory.addDiagnosticItemToList(result, "Environment variables", sb.toString(), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Version", "", "TITLE");
        String title = (String)CONFIG.getPropertyValue(PlatformConfigProperties.ApplicationNameProperty.class);
        String version = (String)CONFIG.getPropertyValue(PlatformConfigProperties.ApplicationVersionProperty.class);
        DiagnosticFactory.addDiagnosticItemToList(result, "Product Name", title, "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Defining Bundle Version", version, "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Change values", "", "TITLE");
        return result;
    }

    private String getDiagnosticItemsXML(List<List<String>> result) {
        StringBuilder buf = new StringBuilder();
        for (List<String> status : result) {
            if (!ObjectUtility.notEquals((Object)"TITLE", (Object)status.get(2))) continue;
            buf.append("<status name='").append(status.get(0)).append("' status='").append(status.get(2)).append("'>");
            buf.append(status.get(1));
            buf.append("</status>");
        }
        return buf.toString();
    }

    private String getDiagnosticItemsHTML(List<List<String>> diagnosticItems) {
        StringBuilder buf = new StringBuilder();
        buf.append("<table>");
        for (List<String> item : diagnosticItems) {
            String style = "";
            String status = item.get(2);
            if ("TITLE".equals(status)) {
                buf.append("<tr><td><b>").append(item.get(0)).append("&nbsp;&nbsp;</b></td><td></td><td></td>");
                continue;
            }
            if ("OK".equals(status) || "ACTIVE".equals(status)) {
                style = " style =\"color:white;background-color:green\"";
            } else if ("FAILED".equals(status) || "INACTIVE".equals(status)) {
                style = " style =\"color:white;background-color:red\"";
            } else if ("INFO".equals(status)) {
                style = " style =\"color:white;background-color:blue\"";
            }
            buf.append("<tr><td style=\"background-color:lightgrey\">").append(item.get(0)).append("&nbsp;&nbsp;</td><td>").append(item.get(1)).append("&nbsp;&nbsp;</td><td").append(style).append("><b>").append(item.get(2)).append("</b></td>");
        }
        buf.append("</table>");
        return buf.toString();
    }

    public static List<String> getSystemInformation() {
        String hostname;
        Runtime rt = Runtime.getRuntime();
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.valueOf(System.getProperty("java.runtime.name")) + " (" + System.getProperty("java.runtime.version") + ")");
        result.add(System.getProperty("user.dir"));
        DecimalFormat df = new DecimalFormat("0.00");
        result.add(String.valueOf(df.format((float)rt.maxMemory() / 1048576.0f)) + " MB");
        result.add(String.valueOf(df.format((float)rt.totalMemory() / 1048576.0f)) + " MB");
        result.add(String.valueOf(df.format((float)(rt.totalMemory() - rt.freeMemory()) / 1048576.0f)) + " MB");
        result.add(System.getProperty("os.arch"));
        result.add(String.valueOf(System.getProperty("os.name")) + " (" + System.getProperty("os.version") + ")");
        result.add(System.getProperty("user.name"));
        result.add(System.getProperty("user.home"));
        result.add(System.getProperty("user.country"));
        result.add(System.getProperty("user.timezone"));
        result.add(String.valueOf(NlsLocale.get().getDisplayLanguage()) + " (L) / " + NlsLocale.get().getLanguage() + " (F)");
        result.add(String.valueOf(rt.availableProcessors()));
        String ip = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ip = addr.getHostAddress();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "Unknown";
            ip = "Unknown";
        }
        result.add(ip);
        result.add(hostname);
        return result;
    }
}

