/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.html.view;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.service.IService;
import org.eclipse.scout.rt.platform.util.BeanUtility;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.server.admin.html.AbstractHtmlAction;
import org.eclipse.scout.rt.server.admin.html.AdminSession;
import org.eclipse.scout.rt.server.admin.html.view.DefaultView;
import org.eclipse.scout.rt.server.admin.html.widget.table.HtmlComponent;
import org.eclipse.scout.rt.server.admin.inspector.ReflectServiceInventory;
import org.eclipse.scout.rt.server.admin.inspector.ServiceInspector;
import org.eclipse.scout.rt.shared.security.UpdateServiceConfigurationPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesView
extends DefaultView {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesView.class);
    private ServiceInspector[] m_serviceInspectors;
    private ServiceInspector m_selectedService;

    public ServicesView(AdminSession as) {
        super(as);
    }

    @Override
    public boolean isVisible() {
        return ACCESS.check((Permission)new UpdateServiceConfigurationPermission());
    }

    @Override
    public void activated() {
        this.m_serviceInspectors = null;
        try {
            ArrayList<ServiceInspector> list = new ArrayList<ServiceInspector>();
            for (IService service : BEANS.all(IService.class)) {
                list.add(new ServiceInspector(service));
            }
            this.m_serviceInspectors = list.toArray(new ServiceInspector[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void produceTitle(HtmlComponent p) {
        p.print("Services");
    }

    @Override
    public void produceBody(HtmlComponent p) {
        p.startTable(0, 5, 5);
        p.startTableRow();
        p.startTableCell();
        this.renderServiceTables(p);
        p.startTableCell();
        if (this.m_selectedService != null) {
            this.renderServiceDetail(p, this.m_selectedService);
        }
        p.endTableCell();
        p.endTableRow();
        p.endTable();
    }

    private void renderServiceTables(HtmlComponent p) {
        TreeMap<CompositeObject, Collection> servicesMap = new TreeMap<CompositeObject, Collection>();
        if (this.m_serviceInspectors != null) {
            ServiceInspector[] serviceInspectorArray = this.m_serviceInspectors;
            int n = this.m_serviceInspectors.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceInspector inspector = serviceInspectorArray[n2];
                String serviceName = inspector.getService().getClass().getSimpleName();
                String sectionName = null;
                try {
                    int sectionOrder;
                    if (serviceName.matches(".*ProcessService")) {
                        sectionOrder = 1;
                        sectionName = "Process Services";
                    } else if (serviceName.matches(".*OutlineService")) {
                        sectionOrder = 2;
                        sectionName = "Outline Services";
                    } else if (serviceName.matches(".*LookupService")) {
                        sectionOrder = 3;
                        sectionName = "Lookup Services";
                    } else {
                        Class topInterface;
                        List serviceInterfaces = BeanUtility.getInterfacesHierarchy(inspector.getService().getClass(), Object.class);
                        Class clazz = topInterface = !serviceInterfaces.isEmpty() ? (Class)serviceInterfaces.get(serviceInterfaces.size() - 1) : null;
                        if (topInterface != null && topInterface.getPackage() != null && topInterface.getPackage().getName().contains(".common.")) {
                            sectionOrder = 4;
                            sectionName = "Common Services";
                        } else {
                            sectionOrder = 5;
                            sectionName = "Other Services";
                        }
                    }
                    CompositeObject key = new CompositeObject(new Object[]{sectionOrder, sectionName});
                    Collection list = servicesMap.computeIfAbsent(key, k -> new ArrayList());
                    list.add(inspector);
                }
                catch (RuntimeException e) {
                    LOG.warn("Failed inspecting service {}", inspector.getService().getClass(), (Object)e);
                }
                ++n2;
            }
        }
        for (Map.Entry e : servicesMap.entrySet()) {
            String sectionName = (String)((CompositeObject)e.getKey()).getComponent(1);
            Collection list = (Collection)e.getValue();
            this.renderServiceTable(p, sectionName, list);
            p.p();
        }
    }

    private void renderServiceTable(HtmlComponent p, String sectionName, Collection<ServiceInspector> serviceInspectors) {
        TreeMap<String, ServiceInspector> sortMap = new TreeMap<String, ServiceInspector>();
        for (ServiceInspector inspector : serviceInspectors) {
            String s = inspector.getService().getClass().getName();
            sortMap.put(s, inspector);
        }
        p.p(sectionName);
        p.startListBox("listBox", 1, true);
        p.listBoxOption(" ", new AbstractHtmlAction("selectService.choose"){

            @Override
            public void run() {
            }
        }, false);
        for (ServiceInspector serviceInspector : sortMap.values()) {
            boolean selected = this.m_selectedService != null && this.m_selectedService.getService() == serviceInspector.getService();
            final ServiceInspector finalServiceInspector = serviceInspector;
            p.listBoxOption(serviceInspector.getService().getClass().getName(), new AbstractHtmlAction("selectService2." + serviceInspector.getService().getClass().getName()){

                @Override
                public void run() {
                    ServicesView.this.m_selectedService = finalServiceInspector;
                }
            }, selected);
        }
        p.endListBox();
    }

    private void renderServiceDetail(HtmlComponent p, ServiceInspector service) {
        ReflectServiceInventory inv;
        p.bold(service.getService().getClass().getSimpleName());
        p.p();
        try {
            inv = service.buildInventory();
        }
        catch (RuntimeException t) {
            p.raw("<font color=red>Inventory failed: " + t + "</font>");
            return;
        }
        this.renderHierarchy(p, service, inv);
        this.renderProperties(p, service, inv);
        this.renderOperations(p, service, inv);
        this.renderStates(p, service, inv);
    }

    private void renderHierarchy(HtmlComponent p, ServiceInspector service, ReflectServiceInventory inv) {
        Class c;
        Class<?> serviceClass = service.getService().getClass();
        ArrayList interfaceHierarchy = new ArrayList();
        Class<?>[] classArray = serviceClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c2 = classArray[n2];
            interfaceHierarchy.addAll(BeanUtility.getInterfacesHierarchy(c2, Object.class));
            ++n2;
        }
        if (interfaceHierarchy.isEmpty()) {
            interfaceHierarchy.addAll(BeanUtility.getInterfacesHierarchy(serviceClass, Object.class));
        }
        interfaceHierarchy.add(serviceClass);
        ArrayList classHierarchy = new ArrayList();
        Class<?> test = service.getService().getClass();
        while (test != null) {
            if (Object.class.isAssignableFrom(test)) {
                classHierarchy.add(0, test);
            }
            test = test.getSuperclass();
        }
        p.pBold("Hierarchy");
        p.startTable(1, 0, 4);
        p.startTableRow();
        p.tableHeaderCell("Interfaces");
        p.tableHeaderCell("Classes");
        p.endTableRow();
        p.startTableRow();
        p.startTableCell();
        String prefix = "";
        Iterator it = interfaceHierarchy.iterator();
        while (it.hasNext()) {
            c = (Class)it.next();
            p.print(String.valueOf(prefix) + c.getName());
            if (!it.hasNext()) continue;
            p.br();
            prefix = String.valueOf(prefix) + "&nbsp;&nbsp;";
        }
        p.endTableCell();
        p.startTableCell();
        prefix = "";
        it = classHierarchy.iterator();
        while (it.hasNext()) {
            c = (Class)it.next();
            p.print(String.valueOf(prefix) + c.getName());
            if (!it.hasNext()) continue;
            p.br();
            prefix = String.valueOf(prefix) + "&nbsp;&nbsp;";
        }
        p.endTableCell();
        p.endTableRow();
        p.endTable();
    }

    private void renderProperties(HtmlComponent p, final ServiceInspector service, ReflectServiceInventory inv) {
        PropertyDescriptor[] properties = inv.getProperties();
        if (properties.length > 0) {
            p.pBold("Properties (" + properties.length + ")");
            p.startTable(1, 0, 4);
            p.startTableRow();
            p.tableHeaderCell("Property name");
            p.tableHeaderCell("Value");
            p.endTableRow();
            PropertyDescriptor[] propertyDescriptorArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                boolean editable;
                PropertyDescriptor desc = propertyDescriptorArray[n2];
                String propName = desc.getName();
                String propValue = "[value not available]";
                if (desc.getReadMethod() != null) {
                    try {
                        propValue = this.formatPropertyValue(desc, desc.getReadMethod().invoke((Object)service.getService(), null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                boolean bl = editable = desc.getWriteMethod() != null;
                if (editable) {
                    final PropertyDescriptor finalDesc = desc;
                    p.startForm(new AbstractHtmlAction("changeProp." + service.getService().getClass().getName() + "." + desc.getName()){

                        @Override
                        public void run() {
                            String propText = this.getFormParameter("value", "");
                            if (propText.isEmpty()) {
                                propText = null;
                            }
                            try {
                                service.changeProperty(finalDesc, propText);
                            }
                            catch (Exception e) {
                                LOG.error("setting {}={}", new Object[]{finalDesc.getName(), propText, e});
                            }
                        }
                    });
                }
                p.startTableRow();
                p.tableCell(propName);
                p.startTableCell();
                if (editable) {
                    p.formTextArea("value", this.getPropertyDisplayValue(propName, propValue));
                    p.formSubmit("Change");
                } else {
                    p.print(this.getPropertyDisplayValue(propName, propValue));
                }
                p.endTableCell();
                p.endTableRow();
                if (editable) {
                    p.endForm();
                }
                ++n2;
            }
            p.endTable();
        }
    }

    private void renderOperations(HtmlComponent p, ServiceInspector service, ReflectServiceInventory inv) {
        Method[] operations = inv.getOperations();
        if (operations.length > 0) {
            p.pBold("Operations (" + operations.length + ")");
            p.startTable(1, 0, 4);
            p.startTableRow();
            p.tableHeaderCell("Operation");
            p.tableHeaderCell("Detail");
            p.endTableRow();
            Method[] methodArray = operations;
            int n = operations.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                p.startTableRow();
                p.tableCell(m.getName());
                p.tableCell(String.valueOf(this.createSignature(m.getReturnType())) + " " + m.getName() + "(" + this.createSignature(m.getParameterTypes()) + ")");
                p.endTableRow();
                ++n2;
            }
            p.endTable();
        }
    }

    private void renderStates(HtmlComponent p, ServiceInspector service, ReflectServiceInventory inv) {
        String[] states = inv.getStates();
        if (states.length > 0) {
            p.pBold("State");
            p.raw("<pre>");
            String[] stringArray = states;
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                p.print(s);
                p.br();
                ++n2;
            }
            p.raw("</pre>");
        }
    }

    private String getPropertyDisplayValue(String propertyName, String propertyValue) {
        if (this.isPropertySuppressed(propertyName)) {
            return "***";
        }
        return propertyValue;
    }

    private boolean isPropertySuppressed(String propertyName) {
        return propertyName != null && propertyName.toLowerCase().contains("password");
    }

    private String formatPropertyValue(PropertyDescriptor p, Object value) {
        Object formattedValue = value;
        return StringUtility.valueOf((Object)formattedValue);
    }

    private String createSignature(Class c) {
        if (c == null) {
            return "void";
        }
        return this.createSignature(new Class[]{c});
    }

    private String createSignature(Class[] a) {
        StringBuilder sig = new StringBuilder();
        Class[] classArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (sig.length() > 0) {
                sig.append(", ");
            }
            sig.append(c.getSimpleName());
            ++n2;
        }
        return sig.toString();
    }
}

