/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.html.view;

import java.security.Permission;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.server.admin.html.AbstractHtmlAction;
import org.eclipse.scout.rt.server.admin.html.AdminSession;
import org.eclipse.scout.rt.server.admin.html.view.DefaultView;
import org.eclipse.scout.rt.server.admin.html.widget.table.HtmlComponent;
import org.eclipse.scout.rt.server.admin.html.widget.table.HtmlTable;
import org.eclipse.scout.rt.server.admin.html.widget.table.SortInfo;
import org.eclipse.scout.rt.server.admin.html.widget.table.VirtualRow;
import org.eclipse.scout.rt.server.admin.inspector.ProcessInspector;
import org.eclipse.scout.rt.server.admin.inspector.SessionInspector;
import org.eclipse.scout.rt.shared.security.UpdateServiceConfigurationPermission;

public class SessionsView
extends DefaultView {
    private SessionInspector m_selectedSession;
    private final SortInfo m_table1SortInfo = new SortInfo();

    public SessionsView(AdminSession as) {
        super(as);
    }

    public SessionInspector getSelectedSession() {
        return this.m_selectedSession;
    }

    @Override
    public boolean isVisible() {
        return ACCESS.check((Permission)new UpdateServiceConfigurationPermission()) && ProcessInspector.instance().isEnabled();
    }

    @Override
    public void produceTitle(HtmlComponent p) {
        p.print("Sessions");
    }

    @Override
    public void produceBody(HtmlComponent p) {
        p.linkAction("Clear sessions", new AbstractHtmlAction("clearSessions"){

            @Override
            public void run() {
                ProcessInspector.instance().clearSessionInspectors();
            }
        });
        p.p();
        this.renderSessionTable(p);
    }

    protected void renderSessionTable(HtmlComponent p) {
        HtmlTable table1 = new HtmlTable(p, "table1", this.m_table1SortInfo);
        table1.startTable(1, 0, 3);
        this.renderSessionTableHeader(table1);
        SessionInspector validSelection = null;
        SessionInspector[] sorted = this.getSortedSessions();
        int i = sorted.length - 1;
        while (i >= 0) {
            if (sorted[i] == this.m_selectedSession) {
                validSelection = this.m_selectedSession;
            }
            VirtualRow vrow = table1.addVirtualRow();
            this.renderSessionRow(vrow, i + 1, sorted[i]);
            --i;
        }
        table1.appendVirtualRows();
        this.m_selectedSession = validSelection;
        table1.endTable();
        p.append(table1);
    }

    protected SessionInspector[] getSortedSessions() {
        SessionInspector[] sessionInspectors = ProcessInspector.instance().getSessionInspectors();
        TreeMap<CompositeObject, SessionInspector> userAndTimeToSessions = new TreeMap<CompositeObject, SessionInspector>();
        int i = 0;
        while (i < sessionInspectors.length) {
            String user = sessionInspectors[i].getInfo().getUserId();
            long lastAccess = NumberUtility.nvl((Long)sessionInspectors[i].getInfo().getLastAccessedTime(), (long)0L);
            userAndTimeToSessions.put(new CompositeObject(new Object[]{lastAccess, user, i}), sessionInspectors[i]);
            ++i;
        }
        return userAndTimeToSessions.values().toArray(new SessionInspector[0]);
    }

    protected void renderSessionTableHeader(HtmlTable table) {
        table.startTableRow();
        table.tableHeaderCell("#");
        table.tableHeaderCell("User");
        table.tableHeaderCell("SessionID");
        table.tableHeaderCell("Details");
        table.tableHeaderCell("Created");
        table.tableHeaderCell("Last&nbsp;accessed");
        table.tableHeaderCell("JAAS");
        table.tableHeaderCell("UserAgent");
        table.endTableRow();
    }

    protected void renderSessionRow(HtmlComponent p, int index, SessionInspector session) {
        p.startTableRow();
        this.renderIndexCell(p, index);
        this.renderUserIdCell(p, session);
        this.renderSessionIdCell(p, session);
        this.renderSessionDetailsCell(p, session);
        this.renderCreatedCell(p, session);
        this.renderLastAccessedCell(p, session);
        this.renderJaasCell(p, session);
        this.renderUserAgentCell(p, session);
        p.endTableRow();
    }

    protected void renderUserAgentCell(HtmlComponent p, SessionInspector session) {
        p.startTableCell();
        p.printNoBreak(session.getInfo().getUserAgent().toString());
        p.endTableCell();
    }

    protected void renderJaasCell(HtmlComponent p, SessionInspector session) {
        p.startTableCell();
        try {
            Subject subject = session.getInfo().getSubject();
            if (subject != null) {
                int i = 0;
                for (Principal principal : subject.getPrincipals()) {
                    if (principal == null) continue;
                    if (i > 0) {
                        p.br();
                    }
                    String s = "principal[" + i + "] name=" + principal.getName() + " toString=" + principal.toString() + " class=" + principal.getClass();
                    s = s.replaceAll("[\\n\\r]+", " ");
                    p.printNoBreak(s);
                    ++i;
                }
            } else {
                p.printNoBreak("no subject available");
            }
        }
        catch (Exception e) {
            p.br();
            p.print("Exception: " + e);
        }
        p.endTableCell();
    }

    protected void renderLastAccessedCell(HtmlComponent p, SessionInspector session) {
        p.startTableCell();
        p.printNoBreak(this.formatTime(session.getInfo().getLastAccessedTime()));
        p.endTableCell();
    }

    protected void renderCreatedCell(HtmlComponent p, SessionInspector session) {
        p.startTableCell();
        p.printNoBreak(this.formatTime(session.getInfo().getCreationTime()));
        p.endTableCell();
    }

    protected void renderSessionDetailsCell(HtmlComponent p, final SessionInspector session) {
        p.startTableCell();
        p.startLinkAction(new AbstractHtmlAction("showServicesOf" + session.getInfo().getSessionId()){

            @Override
            public void run() {
                SessionsView.this.m_selectedSession = session;
                SessionsView.this.getAdminSession().getTopView().showServices();
            }
        });
        p.print("Services");
        p.endLinkAction();
        p.raw("&nbsp;");
        p.startLinkAction(new AbstractHtmlAction("showCallsOf" + session.getInfo().getSessionId()){

            @Override
            public void run() {
                SessionsView.this.m_selectedSession = session;
                SessionsView.this.getAdminSession().getTopView().showCalls();
            }
        });
        p.print("Calls");
        p.endLinkAction();
        p.endTableCell();
    }

    protected void renderSessionIdCell(HtmlComponent p, final SessionInspector session) {
        p.startTableCell();
        if (this.isSelectedSession(session)) {
            p.focusAnchor();
        }
        p.startLinkAction(new AbstractHtmlAction("selectSession" + session.getInfo().getSessionId()){

            @Override
            public void run() {
                SessionsView.this.m_selectedSession = session;
            }
        });
        p.print(session.getInfo().getSessionId());
        p.endLinkAction();
        p.endTableCell();
    }

    protected void renderUserIdCell(HtmlComponent p, SessionInspector session) {
        p.tableCell(session.getInfo().getUserId());
    }

    protected void renderIndexCell(HtmlComponent p, int index) {
        p.tableCell("" + index);
    }

    protected boolean isSelectedSession(SessionInspector session) {
        return this.m_selectedSession != null && this.m_selectedSession == session;
    }

    protected String formatTime(Long timestamp) {
        if (timestamp != null) {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            return format.format(new Date(timestamp));
        }
        return "";
    }
}

