/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.inspector;

import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.server.admin.inspector.SessionInspector;
import org.eclipse.scout.rt.server.admin.inspector.info.CallInfo;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;

public class CallInspector {
    private final SessionInspector m_parent;
    private final CallInfo m_info;

    protected CallInspector(SessionInspector parent, ServiceTunnelRequest call) {
        this.m_parent = parent;
        this.m_info = new CallInfo();
        this.m_info.setStartTime(System.currentTimeMillis());
        this.m_info.setService(call.getServiceInterfaceClassName());
        this.m_info.setOperation(call.getOperation());
        Object[] args = call.getArgs();
        Object[] newArgs = new Object[args != null ? args.length : 0];
        if (newArgs.length > 0) {
            System.arraycopy(args, 0, newArgs, 0, newArgs.length);
        }
        this.m_info.setArguments(newArgs);
    }

    public SessionInspector getSessionInspector() {
        return this.m_parent;
    }

    public boolean isTimeout(long millis) {
        long dt;
        return !this.m_info.isActive() && (dt = System.currentTimeMillis() - this.m_info.getEndTime()) >= millis;
    }

    public void close(ServiceTunnelResponse res) {
        this.update();
        this.m_info.setEndTime(System.currentTimeMillis());
        if (res != null) {
            this.m_info.setReturnData(res.getData());
            this.m_info.setReturnException(res.getException());
        }
    }

    public void update() {
        ITransaction xa = (ITransaction)ITransaction.CURRENT.get();
        if (xa != null) {
            this.m_info.setXaResources(xa.getMembers());
        }
    }

    public CallInfo getInfo() {
        return this.m_info;
    }
}

