/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.collection.ConcurrentExpiringMap;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.admin.inspector.SessionInspector;

@ApplicationScoped
public class ProcessInspector {
    private boolean m_servletInspectorEnabled = false;
    private final Object m_servletInspectorEnabledLock = new Object();
    private volatile ConcurrentExpiringMap<IServerSession, SessionInspector> m_sessionToInspectorMap = new ConcurrentExpiringMap(2L, TimeUnit.MINUTES);
    private final Set<String> m_ignoredCallSet = Collections.synchronizedSet(new HashSet());

    public static ProcessInspector instance() {
        return (ProcessInspector)BEANS.get(ProcessInspector.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.m_servletInspectorEnabledLock;
        synchronized (object) {
            return this.m_servletInspectorEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean b) {
        Object object = this.m_servletInspectorEnabledLock;
        synchronized (object) {
            this.m_servletInspectorEnabled = b;
            if (!b) {
                this.clearSessionInspectors();
            }
        }
    }

    public Set<String> getIgnoredCallSet() {
        return this.m_ignoredCallSet;
    }

    public boolean acceptCall(String serviceClassName, String operation) {
        String callId = String.valueOf(serviceClassName) + "." + operation;
        for (String s : this.m_ignoredCallSet) {
            if (!callId.matches(s)) continue;
            return false;
        }
        return true;
    }

    public void update() {
        SessionInspector[] sessionInspectorArray = this.getSessionInspectors();
        int n = sessionInspectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionInspector i = sessionInspectorArray[n2];
            i.doHousekeeping(this.getTimeout());
            ++n2;
        }
    }

    public long getTimeout() {
        return this.m_sessionToInspectorMap.getTimeToLive();
    }

    public void setTimeout(long timeoutMillis) {
        this.m_sessionToInspectorMap = new ConcurrentExpiringMap(this.m_sessionToInspectorMap, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public SessionInspector[] getSessionInspectors(String user) {
        ArrayList<SessionInspector> a = new ArrayList<SessionInspector>();
        for (SessionInspector si : this.m_sessionToInspectorMap.values()) {
            if (!user.equalsIgnoreCase(si.getInfo().getUserId())) continue;
            a.add(si);
        }
        return a.toArray(new SessionInspector[0]);
    }

    public SessionInspector[] getSessionInspectors() {
        return this.m_sessionToInspectorMap.values().toArray(new SessionInspector[0]);
    }

    public SessionInspector getSessionInspector(IServerSession session, boolean autoCreate) {
        SessionInspector previousInsp;
        SessionInspector insp = (SessionInspector)this.m_sessionToInspectorMap.get((Object)session);
        if (insp == null && this.isEnabled() && autoCreate && (previousInsp = (SessionInspector)this.m_sessionToInspectorMap.putIfAbsent((Object)session, (Object)(insp = new SessionInspector(this, session)))) != null) {
            insp = previousInsp;
        }
        return insp;
    }

    public void clearSessionInspectors(String user) {
        Iterator iterator = this.m_sessionToInspectorMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            SessionInspector session = (SessionInspector)entry.getValue();
            if (!user.equalsIgnoreCase(session.getInfo().getUserId())) continue;
            iterator.remove();
        }
    }

    public void clearSessionInspectors() {
        this.m_sessionToInspectorMap.clear();
    }
}

