/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.clientnotification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.CorrelationId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.server.notification.NotificationCoalescer;
import org.eclipse.scout.rt.shared.clientnotification.ClientNotificationMessage;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationAddress;

@ApplicationScoped
public class ClientNotificationCoalescer {
    public List<ClientNotificationMessage> coalesce(List<ClientNotificationMessage> inNotifications) {
        LinkedHashSet<ClientNotificationMessage> notificationsNoDuplicates = new LinkedHashSet<ClientNotificationMessage>(inNotifications);
        HashMap messagesPerDistributeAndAddress = new HashMap();
        messagesPerDistributeAndAddress.put(true, new HashMap());
        messagesPerDistributeAndAddress.put(false, new HashMap());
        for (ClientNotificationMessage message : notificationsNoDuplicates) {
            Map messagesPerAddress = (Map)messagesPerDistributeAndAddress.get(message.isDistributeOverCluster());
            List messages = messagesPerAddress.computeIfAbsent(message.getAddress(), k -> new ArrayList());
            messages.add(message);
        }
        ArrayList<ClientNotificationMessage> result = new ArrayList<ClientNotificationMessage>();
        for (Map.Entry distributeEntry : messagesPerDistributeAndAddress.entrySet()) {
            boolean distribute = (Boolean)distributeEntry.getKey();
            for (Map.Entry e : ((Map)distributeEntry.getValue()).entrySet()) {
                result.addAll(this.coalesce(distribute, (IClientNotificationAddress)e.getKey(), (List)e.getValue()));
            }
        }
        return result;
    }

    protected List<ClientNotificationMessage> coalesce(boolean distributeOverCluster, IClientNotificationAddress address, List<ClientNotificationMessage> messages) {
        if (messages.isEmpty()) {
            return Collections.emptyList();
        }
        if (messages.size() == 1) {
            ClientNotificationMessage message = (ClientNotificationMessage)CollectionUtility.firstElement(messages);
            return CollectionUtility.arrayList((Object)new ClientNotificationMessage(address, message.getNotification(), message.isDistributeOverCluster(), message.getCorrelationId()));
        }
        LinkedHashMap<Serializable, String> messageMap = new LinkedHashMap<Serializable, String>(messages.size());
        for (ClientNotificationMessage message : messages) {
            messageMap.put(message.getNotification(), message.getCorrelationId());
        }
        List coalescedNotifications = ((NotificationCoalescer)BEANS.get(NotificationCoalescer.class)).coalesce(new ArrayList(messageMap.keySet()));
        ArrayList<ClientNotificationMessage> coalescedMessages = new ArrayList<ClientNotificationMessage>(coalescedNotifications.size());
        for (Serializable coalescedNotification : coalescedNotifications) {
            String cid = messageMap.get(coalescedNotification) != null ? (String)messageMap.get(coalescedNotification) : ((CorrelationId)BEANS.get(CorrelationId.class)).newCorrelationId();
            coalescedMessages.add(new ClientNotificationMessage(address, coalescedNotification, distributeOverCluster, cid));
        }
        return coalescedMessages;
    }
}

