/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.clientnotification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.FinalValue;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationProperties;
import org.eclipse.scout.rt.shared.clientnotification.ClientNotificationMessage;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class ClientNotificationNodeQueue {
    private static final Logger LOG = LoggerFactory.getLogger(ClientNotificationNodeQueue.class);
    private final FinalValue<String> m_nodeId = new FinalValue();
    private final int m_capacity;
    private final BlockingDeque<ClientNotificationMessage> m_notifications;
    private final ReentrantReadWriteLock m_sessionUserCacheLock = new ReentrantReadWriteLock();
    private final Set<String> m_sessions = new HashSet<String>();
    private final Map<String, Set<String>> m_userToSessions = new HashMap<String, Set<String>>();
    private final AtomicLong m_lastConsumeAccess;

    public ClientNotificationNodeQueue() {
        this((Integer)CONFIG.getPropertyValue(ClientNotificationProperties.NodeQueueCapacity.class));
    }

    public ClientNotificationNodeQueue(int capacity) {
        this.m_capacity = capacity;
        this.m_notifications = new LinkedBlockingDeque<ClientNotificationMessage>(capacity);
        this.m_lastConsumeAccess = new AtomicLong(System.currentTimeMillis());
    }

    public void setNodeId(String nodeId) {
        this.m_nodeId.set((Object)nodeId);
    }

    public String getNodeId() {
        return (String)this.m_nodeId.get();
    }

    public int getCapacity() {
        return this.m_capacity;
    }

    public void registerSession(String sessionId, String userId) {
        Assertions.assertNotNull((Object)sessionId);
        Assertions.assertNotNull((Object)userId);
        this.m_sessionUserCacheLock.writeLock().lock();
        try {
            this.m_sessions.add(sessionId);
            Set userSessions = this.m_userToSessions.computeIfAbsent(userId, k -> new HashSet());
            userSessions.add(sessionId);
        }
        finally {
            this.m_sessionUserCacheLock.writeLock().unlock();
        }
    }

    public void unregisterSession(String sessionId, String userId) {
        Assertions.assertNotNull((Object)sessionId);
        Assertions.assertNotNull((Object)userId);
        this.m_sessionUserCacheLock.writeLock().lock();
        try {
            this.m_sessions.remove(sessionId);
            Iterator<Map.Entry<String, Set<String>>> iterator = this.m_userToSessions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Set<String>> entry = iterator.next();
                Set<String> sessions = entry.getValue();
                if (sessions.contains(sessionId)) {
                    sessions.remove(sessionId);
                }
                if (!sessions.isEmpty()) continue;
                iterator.remove();
            }
        }
        finally {
            this.m_sessionUserCacheLock.writeLock().unlock();
        }
    }

    public void put(ClientNotificationMessage notification) {
        this.put(CollectionUtility.arrayList((Object)notification));
    }

    public void put(Collection<? extends ClientNotificationMessage> notificationInput) {
        List<ClientNotificationMessage> notifications = this.getRelevantNotifications(notificationInput);
        this.putDroppingOld(notifications);
    }

    private void putDroppingOld(Collection<? extends ClientNotificationMessage> notifications) {
        int dropCount = 0;
        for (ClientNotificationMessage clientNotificationMessage : notifications) {
            boolean inserted = this.m_notifications.offer(clientNotificationMessage);
            while (!inserted) {
                ClientNotificationMessage removed = this.m_notifications.poll();
                if (removed != null) {
                    ++dropCount;
                }
                inserted = this.m_notifications.offer(clientNotificationMessage);
            }
        }
        if (dropCount > 0) {
            LOG.warn("Notification queue capacity reached. Remove oldest {} notification messages.", (Object)dropCount);
        }
    }

    public long getLastConsumeAccess() {
        return this.m_lastConsumeAccess.get();
    }

    public List<ClientNotificationMessage> consume(int maxAmount, long maxWaitTime, TimeUnit unit) {
        this.m_lastConsumeAccess.set(System.currentTimeMillis());
        List<ClientNotificationMessage> result = this.getNotifications(maxAmount, maxWaitTime, unit);
        LOG.debug("consumed {} notifications.", (Object)result.size());
        return result;
    }

    protected List<ClientNotificationMessage> getNotifications(int maxAmount, long maxWaitTime, TimeUnit unit) {
        LinkedList<ClientNotificationMessage> collected = new LinkedList<ClientNotificationMessage>();
        try {
            ClientNotificationMessage next = this.m_notifications.poll(maxWaitTime, unit);
            if (next != null) {
                collected.add(next);
            }
            int timeout = 234;
            while (next != null && collected.size() < maxAmount) {
                next = this.m_notifications.poll(timeout, TimeUnit.MILLISECONDS);
                if (next == null) continue;
                collected.add(next);
            }
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for client notification messages", (Throwable)e);
        }
        return collected;
    }

    private List<ClientNotificationMessage> getRelevantNotifications(Collection<? extends ClientNotificationMessage> notificationInput) {
        ArrayList<ClientNotificationMessage> notifications = new ArrayList<ClientNotificationMessage>(notificationInput);
        notifications.removeIf(clientNotificationMessage -> !this.isRelevant(clientNotificationMessage.getAddress()));
        return notifications;
    }

    public boolean isRelevant(IClientNotificationAddress address) {
        return address.isNotifyAllSessions() || address.isNotifyAllNodes() || CollectionUtility.containsAny(this.getAllSessionIds(), (Collection)address.getSessionIds()) || CollectionUtility.containsAny(this.getAllUserIds(), (Collection)address.getUserIds());
    }

    public Set<String> getAllSessionIds() {
        this.m_sessionUserCacheLock.readLock().lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.m_sessions);
            return hashSet;
        }
        finally {
            this.m_sessionUserCacheLock.readLock().unlock();
        }
    }

    public Set<String> getAllUserIds() {
        this.m_sessionUserCacheLock.readLock().lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.m_userToSessions.keySet());
            return hashSet;
        }
        finally {
            this.m_sessionUserCacheLock.readLock().unlock();
        }
    }
}

