/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.clientnotification;

import org.eclipse.scout.rt.platform.config.AbstractPositiveIntegerConfigProperty;

public final class ClientNotificationProperties {
    private ClientNotificationProperties() {
    }

    public static class MaxNotificationBlockingTimeOut
    extends AbstractPositiveIntegerConfigProperty {
        public Integer getDefaultValue() {
            return 10000;
        }

        public String description() {
            return "The maximum amount of time in millisecons a consumer blocks while waiting for new notifications. The default is 10 seconds.";
        }

        public String getKey() {
            return "scout.clientnotification.maxNotificationBlockingTimeOut";
        }
    }

    public static class MaxNotificationMessages
    extends AbstractPositiveIntegerConfigProperty {
        public Integer getDefaultValue() {
            return 30;
        }

        public String description() {
            return "The maximum number of client notifications that are consumed at once. The default is 30.";
        }

        public String getKey() {
            return "scout.clientnotification.chunkSize";
        }
    }

    public static class NodeQueueCapacity
    extends AbstractPositiveIntegerConfigProperty {
        public Integer getDefaultValue() {
            return 200;
        }

        public String description() {
            return "Capacity of the client notification queue. If maximum capacity is reached, notification messages are dropped. The default value is 200.";
        }

        public String getKey() {
            return "scout.clientnotification.nodeQueueCapacity";
        }
    }

    public static class NotificationQueueExpireTime
    extends AbstractPositiveIntegerConfigProperty {
        public Integer getDefaultValue() {
            return 600000;
        }

        public String description() {
            return "If no message is consumed for the specified number of milliseconds, client notification queues (with possibly pending notifications) are removed.\nThis avoids overflows and unnecessary memory consumption. Old queues may exist if a node does not properly unregister (e.g. due to a crash).\nThe default value is 10 minutes.";
        }

        public String getKey() {
            return "scout.clientnotification.notificationQueueExpireTime";
        }
    }
}

