/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.clientnotification;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.context.CorrelationId;
import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.platform.transaction.ITransactionMember;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationClusterNotification;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationNodeQueue;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationProperties;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationTransactionMember;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterSynchronizationService;
import org.eclipse.scout.rt.shared.clientnotification.ClientNotificationAddress;
import org.eclipse.scout.rt.shared.clientnotification.ClientNotificationMessage;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ClientNotificationRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ClientNotificationRegistry.class);
    private final Map<String, ClientNotificationNodeQueue> m_notificationQueues = new HashMap<String, ClientNotificationNodeQueue>();
    private final int m_queueExpireTime;

    public ClientNotificationRegistry() {
        this((Integer)Assertions.assertNotNull((Object)((Integer)CONFIG.getPropertyValue(ClientNotificationProperties.NotificationQueueExpireTime.class))));
    }

    public ClientNotificationRegistry(int queueRemoveTimeout) {
        this.m_queueExpireTime = queueRemoveTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSession(String nodeId, String sessionId, String userId) {
        Map<String, ClientNotificationNodeQueue> map = this.m_notificationQueues;
        synchronized (map) {
            this.getQueue(nodeId).registerSession(sessionId, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterSession(String nodeId, String sessionId, String userId) {
        Map<String, ClientNotificationNodeQueue> map = this.m_notificationQueues;
        synchronized (map) {
            ClientNotificationNodeQueue queue = this.getQueue(nodeId);
            queue.unregisterSession(sessionId, userId);
            if (queue.getAllSessionIds().isEmpty()) {
                this.m_notificationQueues.remove(nodeId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterNode(String nodeId) {
        Map<String, ClientNotificationNodeQueue> map = this.m_notificationQueues;
        synchronized (map) {
            this.m_notificationQueues.remove(nodeId);
        }
    }

    List<ClientNotificationMessage> consume(String notificationNodeId, int maxAmount, int maxWaitTime, TimeUnit unit) {
        ClientNotificationNodeQueue queue = this.getQueue(notificationNodeId);
        return queue.consume(maxAmount, maxWaitTime, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientNotificationNodeQueue getQueue(String nodeId) {
        Assertions.assertNotNull((Object)nodeId);
        Map<String, ClientNotificationNodeQueue> map = this.m_notificationQueues;
        synchronized (map) {
            ClientNotificationNodeQueue queue = this.m_notificationQueues.get(nodeId);
            if (queue == null) {
                queue = (ClientNotificationNodeQueue)BEANS.get(ClientNotificationNodeQueue.class);
                queue.setNodeId(nodeId);
                this.m_notificationQueues.put(nodeId, queue);
            }
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRegisteredSessionIds() {
        HashSet<String> allSessionIds = new HashSet<String>();
        Map<String, ClientNotificationNodeQueue> map = this.m_notificationQueues;
        synchronized (map) {
            for (ClientNotificationNodeQueue queue : this.m_notificationQueues.values()) {
                allSessionIds.addAll(queue.getAllSessionIds());
            }
        }
        return allSessionIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRegisteredNodeIds() {
        Map<String, ClientNotificationNodeQueue> map = this.m_notificationQueues;
        synchronized (map) {
            return new HashSet<String>(this.m_notificationQueues.keySet());
        }
    }

    public void putForUser(String userId, Serializable notification) {
        this.putForUser(userId, notification, true);
    }

    public void putForUser(String userId, Serializable notification, boolean distributeOverCluster) {
        this.putForUsers(Collections.singleton(userId), notification, distributeOverCluster);
    }

    public void putForUsers(Set<String> userIds, Serializable notification) {
        this.putForUsers(userIds, notification, true);
    }

    public void putForUsers(Set<String> userIds, Serializable notification, boolean distributeOverCluster) {
        this.publish(ClientNotificationAddress.createUserAddress(userIds), notification, distributeOverCluster);
    }

    public void putForSession(String sessionId, Serializable notification) {
        this.putForSession(sessionId, notification, true);
    }

    public void putForSession(String sessionId, Serializable notification, boolean distributeOverCluster) {
        this.publish(ClientNotificationAddress.createSessionAddress(Collections.singleton(sessionId)), notification, distributeOverCluster);
    }

    public void putForAllSessions(Serializable notification) {
        this.putForAllSessions(notification, true);
    }

    public void putForAllSessions(Serializable notification, boolean distributeOverCluster) {
        this.publish(ClientNotificationAddress.createAllSessionsAddress(), notification, distributeOverCluster);
    }

    public void putForAllNodes(Serializable notification) {
        this.putForAllNodes(notification, true);
    }

    public void putForAllNodes(Serializable notification, boolean distributeOverCluster) {
        this.publish(ClientNotificationAddress.createAllNodesAddress(), notification, distributeOverCluster);
    }

    public void publish(ClientNotificationAddress address, Serializable notification) {
        this.publish(address, notification, true);
    }

    public void publish(ClientNotificationAddress address, Serializable notification, boolean distributeOverCluster) {
        this.publish(Collections.singleton(new ClientNotificationMessage((IClientNotificationAddress)address, notification, distributeOverCluster, (String)CorrelationId.CURRENT.get())));
    }

    public void publish(Collection<? extends ClientNotificationMessage> messages) {
        this.publishWithoutClusterNotification(messages, null);
        this.publishClusterInternal(messages);
    }

    public void publish(Collection<? extends ClientNotificationMessage> messages, String excludedUiNodeId) {
        this.publishWithoutClusterNotification(messages, excludedUiNodeId);
        this.publishClusterInternal(messages);
    }

    public void publishWithoutClusterNotification(Collection<? extends ClientNotificationMessage> messages) {
        this.publishWithoutClusterNotification(messages, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishWithoutClusterNotification(Collection<? extends ClientNotificationMessage> messages, String excludedUiNodeId) {
        Map<String, ClientNotificationNodeQueue> map = this.m_notificationQueues;
        synchronized (map) {
            Iterator<ClientNotificationNodeQueue> iter = this.m_notificationQueues.values().iterator();
            while (iter.hasNext()) {
                ClientNotificationNodeQueue queue = iter.next();
                if (queue.getNodeId().equals(excludedUiNodeId)) continue;
                queue.put(messages);
                if (!this.isQueueExpired(queue)) continue;
                LOG.debug("Removing expired queue {}", (Object)queue.getNodeId());
                iter.remove();
            }
        }
    }

    private boolean isQueueExpired(ClientNotificationNodeQueue queue) {
        long lastAccess;
        long now = System.currentTimeMillis();
        return now - (lastAccess = queue.getLastConsumeAccess()) > (long)this.m_queueExpireTime;
    }

    public void putTransactionalForUser(String userId, Serializable notification) {
        this.putTransactionalForUser(userId, notification, true);
    }

    public void putTransactionalForUser(String userId, Serializable notification, boolean distributeOverCluster) {
        this.putTransactionalForUsers(Collections.singleton(userId), notification, distributeOverCluster);
    }

    public void putTransactionalForUsers(Set<String> userIds, Serializable notification) {
        this.putTransactionalForUsers(userIds, notification, true);
    }

    public void putTransactionalForUsers(Set<String> userIds, Serializable notification, boolean distributeOverCluster) {
        this.putTransactional(ClientNotificationAddress.createUserAddress(userIds), notification, distributeOverCluster);
    }

    public void putTransactionalForSession(String sessionId, Serializable notification) {
        this.putTransactionalForSession(sessionId, notification, true);
    }

    public void putTransactionalForSession(String sessionId, Serializable notification, boolean distributeOverCluster) {
        this.putTransactional(ClientNotificationAddress.createSessionAddress(Collections.singleton(sessionId)), notification, distributeOverCluster);
    }

    public void putTransactionalForAllSessions(Serializable notification) {
        this.putTransactionalForAllSessions(notification, true);
    }

    public void putTransactionalForAllSessions(Serializable notification, boolean distributeOverCluster) {
        this.putTransactional(ClientNotificationAddress.createAllSessionsAddress(), notification, distributeOverCluster);
    }

    public void putTransactionalForAllNodes(Serializable notification) {
        this.putTransactionalForAllNodes(notification, true);
    }

    public void putTransactionalForAllNodes(Serializable notification, boolean distributeOverCluster) {
        this.putTransactional(ClientNotificationAddress.createAllNodesAddress(), notification, distributeOverCluster);
    }

    public void putTransactional(ClientNotificationAddress address, Serializable notification) {
        this.putTransactional(address, notification, true);
    }

    public void putTransactional(ClientNotificationAddress address, Serializable notification, boolean distributeOverCluster) {
        this.putTransactional(new ClientNotificationMessage((IClientNotificationAddress)address, notification, distributeOverCluster, (String)CorrelationId.CURRENT.get()));
    }

    public void putTransactional(ClientNotificationMessage message) {
        ITransaction transaction = (ITransaction)Assertions.assertNotNull((Object)((ITransaction)ITransaction.CURRENT.get()), (String)"No transaction found on current calling context to register transactional client notification {}", (Object[])new Object[]{message});
        try {
            ClientNotificationTransactionMember txMember = (ClientNotificationTransactionMember)transaction.getMember("clientNotification.transactionMemberId");
            if (txMember == null) {
                txMember = new ClientNotificationTransactionMember(this);
                transaction.registerMember((ITransactionMember)txMember);
            }
            txMember.addNotification(message);
        }
        catch (RuntimeException e) {
            LOG.warn("Could not register transaction member. The notification will be processed immediately", (Throwable)e);
            this.publish(Collections.singleton(message));
        }
    }

    private void publishClusterInternal(Collection<? extends ClientNotificationMessage> messages) {
        LinkedList<ClientNotificationMessage> filteredMessages = new LinkedList<ClientNotificationMessage>();
        for (ClientNotificationMessage clientNotificationMessage : messages) {
            if (!clientNotificationMessage.isDistributeOverCluster()) continue;
            filteredMessages.add(clientNotificationMessage);
        }
        if (filteredMessages.isEmpty()) {
            return;
        }
        try {
            IClusterSynchronizationService iClusterSynchronizationService = (IClusterSynchronizationService)BEANS.get(IClusterSynchronizationService.class);
            iClusterSynchronizationService.publish(new ClientNotificationClusterNotification(filteredMessages));
        }
        catch (RuntimeException runtimeException) {
            LOG.error("Failed to publish client notification", (Throwable)runtimeException);
        }
    }
}

