/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.context;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.server.context.HttpServerRunContextProducer;

public class HttpServerRunContextFilter
implements Filter {
    private HttpServerRunContextProducer m_producer;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_producer = this.createRunContextProducer().withSessionSupport(this.hasSessionSupport(filterConfig));
    }

    protected boolean hasSessionSupport(FilterConfig filterConfig) {
        return !"false".equalsIgnoreCase(filterConfig.getInitParameter("session"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.buildRunContext(req, resp).run(() -> chain.doFilter(request, response));
    }

    protected RunContext buildRunContext(HttpServletRequest req, HttpServletResponse resp) {
        return this.getRunContextProducer().produce(req, resp);
    }

    protected HttpServerRunContextProducer createRunContextProducer() {
        return (HttpServerRunContextProducer)BEANS.get(HttpServerRunContextProducer.class);
    }

    protected HttpServerRunContextProducer getRunContextProducer() {
        return this.m_producer;
    }

    public void destroy() {
        this.m_producer = null;
    }
}

