/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.context;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.commons.HttpSessionMutex;
import org.eclipse.scout.rt.server.commons.context.HttpRunContextProducer;
import org.eclipse.scout.rt.server.commons.servlet.HttpClientInfo;
import org.eclipse.scout.rt.server.context.ServerRunContext;
import org.eclipse.scout.rt.server.context.ServerRunContexts;
import org.eclipse.scout.rt.server.session.ServerSessionCache;
import org.eclipse.scout.rt.server.session.ServerSessionLifecycleHandler;
import org.eclipse.scout.rt.shared.session.Sessions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class HttpServerRunContextProducer {
    public static final String SCOUT_SESSION_ID_KEY = String.valueOf(HttpServerRunContextProducer.class.getName()) + ".SCOUT_SESSION_ID";
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerRunContextProducer.class);
    private final ServerSessionCache m_serverSessionCache = this.createServerSessionCache();
    private final HttpRunContextProducer m_innerRunContextProducer = this.createRunContextProducer();
    private boolean m_sessionSupport = true;

    public ServerRunContext produce(HttpServletRequest req, HttpServletResponse resp) {
        return this.produce(req, resp, null, null);
    }

    public ServerRunContext produce(HttpServletRequest req, HttpServletResponse resp, String scoutSessionId, ServerRunContext existingContext) {
        ServerRunContext contextToFill = existingContext;
        if (contextToFill == null) {
            contextToFill = ServerRunContexts.copyCurrent(true);
        }
        ServerRunContext serverRunContext = (ServerRunContext)this.getInnerRunContextProducer().produce(req, resp, (RunContext)contextToFill);
        serverRunContext.withUserAgent(HttpClientInfo.get((HttpServletRequest)req).toUserAgents().build());
        if (!this.hasSessionSupport()) {
            return serverRunContext;
        }
        IServerSession session = this.getOrCreateScoutSession(req, serverRunContext, scoutSessionId);
        return serverRunContext.withSession(session);
    }

    public IServerSession getOrCreateScoutSession(HttpServletRequest req, ServerRunContext serverRunContextForSessionStart) {
        return this.getOrCreateScoutSession(req, serverRunContextForSessionStart, null);
    }

    public IServerSession getOrCreateScoutSession(HttpServletRequest req, ServerRunContext serverRunContextForSessionStart, String scoutSessionId) {
        if (!this.hasSessionSupport()) {
            return null;
        }
        HttpSession httpSession = req.getSession();
        String sid = this.ensureScoutSessionId(scoutSessionId, httpSession);
        ServerSessionLifecycleHandler lifecycleHandler = new ServerSessionLifecycleHandler(sid, serverRunContextForSessionStart);
        IServerSession session = this.getServerSessionCache().getOrCreate(lifecycleHandler, httpSession);
        if (session == null) {
            LOG.warn("{} is configured to create a Scout session but no class implementing {} could be found. Consider disabling session support.", (Object)HttpServerRunContextProducer.class.getName(), (Object)IServerSession.class.getName());
        }
        return session;
    }

    protected String ensureScoutSessionId(String scoutSessionId, HttpSession httpSession) {
        if (StringUtility.hasText((CharSequence)scoutSessionId)) {
            return scoutSessionId;
        }
        return this.computeSessionIdIfAbsent(httpSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String computeSessionIdIfAbsent(HttpSession httpSession) {
        Object object = HttpSessionMutex.of((HttpSession)httpSession);
        synchronized (object) {
            String scoutSessionId = (String)httpSession.getAttribute(SCOUT_SESSION_ID_KEY);
            if (StringUtility.hasText((CharSequence)scoutSessionId)) {
                return scoutSessionId;
            }
            scoutSessionId = Sessions.randomSessionId();
            httpSession.setAttribute(SCOUT_SESSION_ID_KEY, (Object)scoutSessionId);
            return scoutSessionId;
        }
    }

    public HttpServerRunContextProducer withSessionSupport(boolean sessionSupport) {
        this.m_sessionSupport = sessionSupport;
        return this;
    }

    public boolean hasSessionSupport() {
        return this.m_sessionSupport;
    }

    protected HttpRunContextProducer createRunContextProducer() {
        return (HttpRunContextProducer)BEANS.get(HttpRunContextProducer.class);
    }

    public HttpRunContextProducer getInnerRunContextProducer() {
        return this.m_innerRunContextProducer;
    }

    protected ServerSessionCache createServerSessionCache() {
        return (ServerSessionCache)BEANS.get(ServerSessionCache.class);
    }

    public ServerSessionCache getServerSessionCache() {
        return this.m_serverSessionCache;
    }
}

