/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.index.AbstractMultiValueIndex;
import org.eclipse.scout.rt.platform.index.AbstractSingleValueIndex;
import org.eclipse.scout.rt.platform.index.IIndex;
import org.eclipse.scout.rt.platform.index.IndexedStore;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;

@ApplicationScoped
public class RunMonitorCancelRegistry {
    private boolean m_destroyed;
    protected final IndexedStore<RegistryEntry> m_registry;
    private final Object m_registryLock = new Object();
    protected final P_RunMonitorIndex m_runMonitorIndex = new P_RunMonitorIndex();
    protected final P_SessionIdIndex m_sessionIdIndex = new P_SessionIdIndex();
    protected final P_SessionIdRequestIdIndex m_sessionIdRequestIdIndex = new P_SessionIdRequestIdIndex();

    public RunMonitorCancelRegistry() {
        this.m_registry = new IndexedStore();
        this.m_registry.registerIndex((IIndex)this.m_runMonitorIndex);
        this.m_registry.registerIndex((IIndex)this.m_sessionIdIndex);
        this.m_registry.registerIndex((IIndex)this.m_sessionIdRequestIdIndex);
    }

    public IRegistrationHandle register(RunMonitor runMonitor) {
        return this.register(runMonitor, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegistrationHandle register(RunMonitor runMonitor, String sessionId, Long requestId) {
        RegistryEntry entry = new RegistryEntry(runMonitor, sessionId, requestId);
        Object object = this.m_registryLock;
        synchronized (object) {
            Assertions.assertFalse((boolean)this.m_destroyed, (String)"{} not available because the platform has been shut down.", (Object[])new Object[]{this.getClass().getSimpleName()});
            this.m_registry.add((Object)entry);
        }
        return () -> {
            Object object = this.m_registryLock;
            synchronized (object) {
                this.m_registry.remove((Object)entry);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelAll() {
        List registryEntries;
        Object object = this.m_registryLock;
        synchronized (object) {
            registryEntries = this.m_runMonitorIndex.values();
            this.m_registry.remove((Collection)registryEntries);
        }
        return this.cancelRunMonitors(this.getRunMonitors(registryEntries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelAllBySessionId(String sessionId) {
        List registryEntries;
        RunMonitor currentRunMonitor = (RunMonitor)RunMonitor.CURRENT.get();
        Object object = this.m_registryLock;
        synchronized (object) {
            registryEntries = this.m_sessionIdIndex.get(sessionId);
            registryEntries.removeIf(next -> next.getRunMonitor() == currentRunMonitor);
            this.m_registry.remove((Collection)registryEntries);
        }
        return this.cancelRunMonitors(this.getRunMonitors(registryEntries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelAllBySessionIdAndRequestId(String sessionId, long requestId) {
        List entries;
        Object object = this.m_registryLock;
        synchronized (object) {
            entries = this.m_sessionIdRequestIdIndex.get(new CompositeObject(new Object[]{sessionId, requestId}));
            this.m_registry.remove((Collection)entries);
        }
        return this.cancelRunMonitors(this.getRunMonitors(entries));
    }

    protected List<RunMonitor> getRunMonitors(List<RegistryEntry> registryEntries) {
        ArrayList<RunMonitor> runMonitors = new ArrayList<RunMonitor>(registryEntries.size());
        for (RegistryEntry registryEntry : registryEntries) {
            runMonitors.add(registryEntry.getRunMonitor());
        }
        return runMonitors;
    }

    protected boolean cancelRunMonitors(List<RunMonitor> runMonitors) {
        HashSet<Boolean> status = new HashSet<Boolean>();
        for (RunMonitor runMonitor : runMonitors) {
            status.add(runMonitor.cancel(true));
        }
        return Collections.singleton(Boolean.TRUE).equals(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.m_registryLock;
        synchronized (object) {
            this.m_destroyed = true;
        }
        this.cancelAll();
    }

    protected Set<RunMonitor> getAll() {
        return this.m_runMonitorIndex.indexValues();
    }

    protected List<RunMonitor> getAllBySession(String sessionId) {
        return this.getRunMonitors(this.m_sessionIdIndex.get(sessionId));
    }

    protected List<RunMonitor> getAllBySessionIdAndRequestId(String sessionId, long requestId) {
        return this.getRunMonitors(this.m_sessionIdRequestIdIndex.get(new CompositeObject(new Object[]{sessionId, requestId})));
    }

    @FunctionalInterface
    public static interface IRegistrationHandle {
        public void unregister();
    }

    protected static class P_RunMonitorIndex
    extends AbstractSingleValueIndex<RunMonitor, RegistryEntry> {
        protected P_RunMonitorIndex() {
        }

        protected RunMonitor calculateIndexFor(RegistryEntry runMonitorEntry) {
            return runMonitorEntry.getRunMonitor();
        }
    }

    protected static class P_SessionIdIndex
    extends AbstractMultiValueIndex<String, RegistryEntry> {
        protected P_SessionIdIndex() {
        }

        protected String calculateIndexFor(RegistryEntry runMonitorEntry) {
            return runMonitorEntry.getSessionId();
        }
    }

    protected static class P_SessionIdRequestIdIndex
    extends AbstractMultiValueIndex<CompositeObject, RegistryEntry> {
        protected P_SessionIdRequestIdIndex() {
        }

        protected CompositeObject calculateIndexFor(RegistryEntry runMonitorEntry) {
            return new CompositeObject(new Object[]{runMonitorEntry.getSessionId(), runMonitorEntry.getRequestId()});
        }
    }

    public static class PlatformListener
    implements IPlatformListener {
        public void stateChanged(PlatformEvent event) {
            if (event.getState() == IPlatform.State.PlatformStopping) {
                ((RunMonitorCancelRegistry)BEANS.get(RunMonitorCancelRegistry.class)).destroy();
            }
        }
    }

    protected static class RegistryEntry {
        private final RunMonitor m_runMonitor;
        private final String m_sessionId;
        private final Long m_requestId;

        public RegistryEntry(RunMonitor runMonitor, String sessionId, Long requestId) {
            this.m_runMonitor = runMonitor;
            this.m_sessionId = sessionId;
            this.m_requestId = requestId;
        }

        public RunMonitor getRunMonitor() {
            return this.m_runMonitor;
        }

        public String getSessionId() {
            return this.m_sessionId;
        }

        public Long getRequestId() {
            return this.m_requestId;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).attr("runMonitor", (Object)this.m_runMonitor).attr("sessionId", this.m_sessionId).attr("requestId", (Object)this.m_requestId).toString();
        }
    }
}

